/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.region;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class CuboidRegion
implements Iterable<Block> {
    private final Location pos1;
    private final Location pos2;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int nextX = this.min().getBlockX();
    private int nextY = this.min().getBlockY();
    private int nextZ = this.min().getBlockZ();

    public CuboidRegion(Location pos1, Location pos2) {
        this.maxX = this.max().getBlockX();
        this.maxY = this.max().getBlockY();
        this.maxZ = this.max().getBlockZ();
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @Override
    public Iterator<Block> iterator() {
        return new Iterator<Block>(){

            @Override
            public boolean hasNext() {
                return CuboidRegion.this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public Block next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Block result = new Location(CuboidRegion.this.pos1.getWorld(), (double)CuboidRegion.this.nextX, (double)CuboidRegion.this.nextY, (double)CuboidRegion.this.nextZ).getBlock();
                this.forwardOne();
                this.forward();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void forwardOne() {
                if (++CuboidRegion.this.nextX <= CuboidRegion.this.maxX) {
                    return;
                }
                CuboidRegion.this.nextX = CuboidRegion.this.min().getBlockX();
                if (++CuboidRegion.this.nextY <= CuboidRegion.this.maxY) {
                    return;
                }
                CuboidRegion.this.nextY = CuboidRegion.this.min().getBlockY();
                if (++CuboidRegion.this.nextZ <= CuboidRegion.this.maxZ) {
                    return;
                }
                CuboidRegion.this.nextX = Integer.MIN_VALUE;
            }

            public void forward() {
                while (this.hasNext() && !CuboidRegion.this.checkHas((Vector)new BlockVector(CuboidRegion.this.nextX, CuboidRegion.this.nextY, CuboidRegion.this.nextZ))) {
                    this.forwardOne();
                }
            }
        };
    }

    public Vector min() {
        return new Vector(Math.min(this.pos1.getBlockX(), this.pos2.getBlockX()), Math.min(this.pos1.getBlockY(), this.pos2.getBlockY()), Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ()));
    }

    public Vector max() {
        return new Vector(Math.max(this.pos1.getBlockX(), this.pos2.getBlockX()), Math.max(this.pos1.getBlockY(), this.pos2.getBlockY()), Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ()));
    }

    public boolean checkHas(Vector pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        Vector min = this.min();
        Vector max = this.max();
        return x >= (double)min.getBlockX() && x <= (double)max.getBlockX() && y >= (double)min.getBlockY() && y <= (double)max.getBlockY() && z >= (double)min.getBlockZ() && z <= (double)max.getBlockZ();
    }
}

