/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.util.Collect;
import com.w00tmast3r.skquery.util.minecraft.MoonPhase;
import org.bukkit.World;
import org.bukkit.event.Event;

@UsePropertyPatterns
@PropertyFrom(value="world")
@PropertyTo(value="[current] moon phase")
public class ExprMoonPhase
extends SimplePropertyExpression<World, MoonPhase> {
    protected String getPropertyName() {
        return "moon phase";
    }

    public MoonPhase convert(World world) {
        return this.getPhaseOf(world);
    }

    public Class<? extends MoonPhase> getReturnType() {
        return MoonPhase.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.SET ? Collect.asArray(MoonPhase.class) : null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        MoonPhase moonPhase = delta[0] == null ? MoonPhase.FULL_MOON : (MoonPhase)((Object)delta[0]);
        World w = (World)this.getExpr().getSingle(e);
        if (w == null || this.getPhaseOf(w) == moonPhase) {
            return;
        }
        while (this.getPhaseOf(w) != moonPhase) {
            w.setFullTime(w.getFullTime() + 24000L);
        }
    }

    private MoonPhase getPhaseOf(World world) {
        long days = world.getFullTime() / 24000L;
        int phase = (int)(days % 8L);
        switch (phase) {
            case 0: {
                return MoonPhase.FULL_MOON;
            }
            case 1: {
                return MoonPhase.WANING_GIBBOUS;
            }
            case 2: {
                return MoonPhase.LAST_QUARTER;
            }
            case 3: {
                return MoonPhase.WANING_CRESCENT;
            }
            case 4: {
                return MoonPhase.NEW_MOON;
            }
            case 5: {
                return MoonPhase.WAXING_CRESCENT;
            }
            case 6: {
                return MoonPhase.FIRST_QUARTER;
            }
            case 7: {
                return MoonPhase.WAXING_GIBBOUS;
            }
        }
        return MoonPhase.FULL_MOON;
    }
}

