/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Prime")
@Description(value="Checks whether or not a number is prime.")
@Patterns(value={"%number% is [a] prime [number]", "%number% is not [a] prime [number]"})
public class CondIsPrime
extends Condition {
    private Expression<Number> number;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.number = expressions[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        return this.number.check(event, (Checker)new Checker<Number>(){

            public boolean check(Number number) {
                return CondIsPrime.isPrime(number.intValue());
            }
        }, this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return this.number.toString(event, debug) + " is a prime";
    }

    public static boolean isPrime(int number) {
        if (number % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= number) {
            if (number % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }
}

