/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Collect;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Patterns(value={"player from [uuid] %string%"})
public class ExprUUIDToPlayer
extends SimpleExpression<Player> {
    private Expression<String> uuid;

    protected Player[] get(Event e) {
        UUID uniqueId;
        String player = (String)this.uuid.getSingle(e);
        if (player == null) {
            return null;
        }
        try {
            uniqueId = UUID.fromString(player);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        return Collect.asArray(Bukkit.getPlayer((UUID)uniqueId));
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public String toString(Event e, boolean debug) {
        return "player from uuid";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.uuid = exprs[0];
        return true;
    }
}

