/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Collect;
import com.w00tmast3r.skquery.util.minecraft.Utils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Client Sign")
@Description(value="Cause a sign to have custom lines to certain viewers")
@Examples(value={"command /hidesign:;->trigger:;->->make all players see lines of targeted block as \"\", \"\", \"\", \"\""})
@Patterns(value={"make %players% see lines of %blocks% as %string%, %string%, %string%( and|,) %string%"})
public class EffClientSign
extends Effect {
    private Expression<String> line1;
    private Expression<String> line2;
    private Expression<String> line3;
    private Expression<String> line4;
    private Expression<Player> players;
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = expressions[0];
        this.blocks = expressions[1];
        this.line1 = expressions[2];
        this.line2 = expressions[3];
        this.line3 = expressions[4];
        this.line4 = expressions[5];
        return true;
    }

    protected void execute(Event event) {
        String l1 = (String)this.line1.getSingle(event);
        String l2 = (String)this.line2.getSingle(event);
        String l3 = (String)this.line3.getSingle(event);
        String l4 = (String)this.line4.getSingle(event);
        Block[] blockArray = (Block[])this.blocks.getArray(event);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block block = blockArray[n2];
            Material material = block.getType();
            if (material == Utils.materialAttempt("SIGN_POST", "SIGN") || material == Material.WALL_SIGN || material == Material.SIGN) {
                Player[] playerArray = (Player[])this.players.getArray(event);
                int n3 = playerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Player player = playerArray[n4];
                    player.sendSignChange(block.getLocation(), Collect.asArray(l1, l2, l3, l4));
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public String toString(Event event, boolean debug) {
        return "client sign for " + this.players.toString(event, debug);
    }
}

