/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.region.CuboidRegion;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Is Within Cuboid")
@Description(value="Checks whether or not a certain location is included in a 3d cube with 2 endpoints.")
@Patterns(value={"%locations% (is|are) within %location% (to|and) %location%", "%locations% (are|is)(n't| not) within %location% (to|and) %location%"})
public class CondIsWithin
extends Condition {
    private Expression<Location> locations;
    private Expression<Location> pos1;
    private Expression<Location> pos2;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.locations = expressions[0];
        this.pos1 = expressions[1];
        this.pos2 = expressions[2];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        Location p1 = (Location)this.pos1.getSingle(event);
        Location p2 = (Location)this.pos2.getSingle(event);
        return this.locations.check(event, (Checker)new Checker<Location>(){

            public boolean check(Location location) {
                if (location == null || p1 == null || p2 == null) {
                    return false;
                }
                return new CuboidRegion(p1, p2).checkHas(location.toVector());
            }
        }, this.isNegated());
    }

    public String toString(Event event, boolean debug) {
        return this.locations.toString(event, debug) + " are within cuboid from " + this.pos1.toString(event, debug) + " to " + this.pos2.toString(event, debug);
    }
}

