/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.yggdrasil.Fields;
import com.w00tmast3r.skquery.api.AbstractTask;
import com.w00tmast3r.skquery.skript.LambdaCondition;
import com.w00tmast3r.skquery.skript.LambdaEffect;
import com.w00tmast3r.skquery.skript.Markup;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Types
extends AbstractTask {
    @Override
    public void run() {
        Classes.registerClass((ClassInfo)new ClassInfo(Markup.class, "markup").parser((Parser)new Parser<Markup>(){

            public Markup parse(String s, ParseContext parseContext) {
                if (s.charAt(0) == '`' && s.charAt(s.length() - 1) == '`') {
                    return new Markup(s.substring(1, s.length() - 1));
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(Markup markup, int i) {
                return markup.toString();
            }

            public String toVariableNameString(Markup markup) {
                return markup.toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }).serializer((Serializer)new Serializer<Markup>(){

            public Fields serialize(Markup markup) throws NotSerializableException {
                Fields f = new Fields();
                f.putObject("src", (Object)markup.toString());
                return f;
            }

            public void deserialize(Markup markup, Fields fieldContexts) throws StreamCorruptedException, NotSerializableException {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            protected Markup deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                return new Markup((String)fields.getObject("src"));
            }

            public boolean mustSyncDeserialization() {
                return true;
            }

            public boolean canBeInstantiated(Class<? extends Markup> aClass) {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(LambdaCondition.class, "predicate").parser((Parser)new Parser<LambdaCondition>(){

            public LambdaCondition parse(String s, ParseContext parseContext) {
                if (s.length() > 2 && s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                    Condition e = Condition.parse((String)s.substring(1, s.length() - 1), null);
                    if (e == null) {
                        Skript.error((String)(String.valueOf(s) + " is not a valid lambda statement."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    } else {
                        return new LambdaCondition(e);
                    }
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(LambdaCondition lambdaCondition, int i) {
                return lambdaCondition.toString();
            }

            public String toVariableNameString(LambdaCondition lambdaCondition) {
                return lambdaCondition.toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(LambdaEffect.class, "lambda").parser((Parser)new Parser<LambdaEffect>(){

            public LambdaEffect parse(String s, ParseContext parseContext) {
                if (s.length() > 3 && s.charAt(0) == '[' && s.charAt(s.length() - 1) == ']') {
                    if ("void".equals(s.substring(1, s.length() - 1))) {
                        return new LambdaEffect(true);
                    }
                    Effect e = Effect.parse((String)s.substring(1, s.length() - 1), null);
                    if (e == null) {
                        Skript.error((String)(String.valueOf(s) + " is not a valid lambda statement."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
                    } else {
                        return new LambdaEffect(e);
                    }
                }
                return null;
            }

            public boolean canParse(ParseContext context) {
                return true;
            }

            public String toString(LambdaEffect lambdaEffect, int i) {
                return lambdaEffect.toString();
            }

            public String toVariableNameString(LambdaEffect lambdaEffect) {
                return lambdaEffect.toString();
            }

            public String getVariableNamePattern() {
                return ".+";
            }
        }));
        if (Skript.classExists((String)"org.bukkit.Color")) {
            Classes.registerClass((ClassInfo)new ClassInfo(org.bukkit.Color.class, "rgbcolor").parser((Parser)new Parser<org.bukkit.Color>(){

                public org.bukkit.Color parse(String s, ParseContext context) {
                    Matcher m = Pattern.compile("([0-9]{1,3})\\s*,\\s*([0-9]{1,3})\\s*,\\s*([0-9]{1,3})").matcher(s);
                    if (m.matches()) {
                        int r = Integer.parseInt(m.group(1));
                        int g = Integer.parseInt(m.group(2));
                        int b = Integer.parseInt(m.group(3));
                        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
                            return null;
                        }
                        return org.bukkit.Color.fromRGB((int)r, (int)g, (int)b);
                    }
                    Color c = Color.byName((String)s);
                    if (c == null) {
                        return null;
                    }
                    return c.getBukkitColor();
                }

                public String toString(org.bukkit.Color c, int flags) {
                    return c.toString();
                }

                public String toVariableNameString(org.bukkit.Color o) {
                    return o.toString();
                }

                public String getVariableNamePattern() {
                    return ".+";
                }
            }).serializer((Serializer)new Serializer<org.bukkit.Color>(){

                public Fields serialize(org.bukkit.Color o) throws NotSerializableException {
                    Fields f = new Fields();
                    f.putPrimitive("rgb", (Object)o.asRGB());
                    return f;
                }

                public void deserialize(org.bukkit.Color o, Fields f) throws StreamCorruptedException, NotSerializableException {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }

                protected org.bukkit.Color deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                    return org.bukkit.Color.fromRGB((int)((Integer)fields.getPrimitive("rgb", Integer.TYPE)));
                }

                public boolean mustSyncDeserialization() {
                    return true;
                }

                public boolean canBeInstantiated(Class<? extends org.bukkit.Color> c) {
                    return false;
                }

                protected boolean canBeInstantiated() {
                    return false;
                }
            }));
        }
    }
}

