/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.note;

import ch.njol.skript.Skript;
import com.w00tmast3r.skquery.util.note.Instrument;
import com.w00tmast3r.skquery.util.note.NoteBlockReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class MidiUtil {
    private static HashMap<String, Sequencer> playing = new HashMap();
    private static final int[] instruments;
    private static final int[] percussion;

    static {
        int[] nArray = new int[128];
        nArray[7] = 5;
        nArray[8] = 9;
        nArray[9] = 9;
        nArray[10] = 9;
        nArray[11] = 9;
        nArray[12] = 9;
        nArray[13] = 6;
        nArray[15] = 9;
        nArray[16] = 9;
        nArray[23] = 5;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        nArray[28] = 5;
        nArray[29] = 5;
        nArray[30] = 5;
        nArray[31] = 1;
        nArray[32] = 1;
        nArray[33] = 1;
        nArray[34] = 1;
        nArray[35] = 1;
        nArray[36] = 1;
        nArray[37] = 1;
        nArray[38] = 1;
        nArray[39] = 5;
        nArray[40] = 1;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 5;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 8;
        nArray[52] = 8;
        nArray[53] = 8;
        nArray[54] = 8;
        nArray[55] = 8;
        nArray[56] = 8;
        nArray[57] = 8;
        nArray[58] = 8;
        nArray[59] = 8;
        nArray[60] = 8;
        nArray[61] = 8;
        nArray[62] = 8;
        nArray[63] = 8;
        nArray[64] = 8;
        nArray[65] = 8;
        nArray[66] = 8;
        nArray[67] = 8;
        nArray[68] = 8;
        nArray[69] = 8;
        nArray[70] = 8;
        nArray[71] = 8;
        nArray[72] = 8;
        nArray[73] = 8;
        nArray[74] = 8;
        nArray[75] = 8;
        nArray[76] = 8;
        nArray[77] = 8;
        nArray[78] = 8;
        nArray[79] = 8;
        nArray[103] = 5;
        nArray[104] = 5;
        nArray[105] = 5;
        nArray[106] = 5;
        nArray[107] = 9;
        nArray[108] = 8;
        nArray[109] = 5;
        nArray[110] = 8;
        nArray[111] = 6;
        nArray[112] = 6;
        nArray[113] = 3;
        nArray[114] = 3;
        nArray[115] = 2;
        nArray[116] = 2;
        nArray[117] = 2;
        nArray[118] = 6;
        nArray[119] = 5;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        nArray[123] = 6;
        nArray[124] = 1;
        nArray[125] = 2;
        nArray[126] = 4;
        nArray[127] = 7;
        instruments = nArray;
        int[] nArray2 = new int[50];
        nArray2[0] = 9;
        nArray2[1] = 6;
        nArray2[2] = 4;
        nArray2[3] = 4;
        nArray2[4] = 3;
        nArray2[5] = 2;
        nArray2[6] = 3;
        nArray2[7] = 2;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 2;
        nArray2[12] = 2;
        nArray2[13] = 2;
        nArray2[14] = 2;
        nArray2[15] = 2;
        nArray2[16] = 7;
        nArray2[17] = 2;
        nArray2[18] = 7;
        nArray2[19] = 7;
        nArray2[20] = 6;
        nArray2[21] = 3;
        nArray2[22] = 7;
        nArray2[23] = 6;
        nArray2[24] = 7;
        nArray2[25] = 3;
        nArray2[26] = 7;
        nArray2[27] = 2;
        nArray2[28] = 2;
        nArray2[29] = 3;
        nArray2[30] = 3;
        nArray2[31] = 3;
        nArray2[32] = 2;
        nArray2[33] = 2;
        nArray2[34] = 6;
        nArray2[35] = 6;
        nArray2[36] = 2;
        nArray2[37] = 2;
        nArray2[40] = 3;
        nArray2[41] = 3;
        nArray2[42] = 3;
        nArray2[43] = 3;
        nArray2[44] = 3;
        nArray2[45] = 3;
        nArray2[46] = 5;
        nArray2[47] = 5;
        nArray2[48] = 10;
        nArray2[49] = 10;
        percussion = nArray2;
    }

    private static void playMidi(Sequence sequence, float tempo, String ID, Player ... listeners) {
        try {
            Sequencer sequencer = MidiSystem.getSequencer(false);
            sequencer.setSequence(sequence);
            sequencer.open();
            sequencer.setTempoFactor(tempo);
            NoteBlockReceiver reciever = new NoteBlockReceiver(ID, listeners);
            sequencer.getTransmitter().setReceiver(reciever);
            sequencer.start();
            playing.put(ID.toLowerCase(), sequencer);
        }
        catch (InvalidMidiDataException | MidiUnavailableException e) {
            Skript.exception((Throwable)e, (String[])new String[]{"Error attempting to play a midi file"});
        }
    }

    public static void playMidi(File file, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(MidiSystem.getSequence(file), tempo, ID, listeners);
    }

    public static void playMidi(InputStream stream, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(MidiSystem.getSequence(stream), tempo, ID, listeners);
    }

    public static void playMidiQuietly(File file, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(file, tempo, ID, listeners);
    }

    public static void playMidiQuietly(InputStream stream, float tempo, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidi(stream, tempo, ID, listeners);
    }

    public static void playMidiQuietly(File file, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidiQuietly(file, 1.0f, ID, listeners);
    }

    public static void playMidiQuietly(InputStream stream, String ID, Player ... listeners) throws InvalidMidiDataException, IOException {
        MidiUtil.playMidiQuietly(stream, 1.0f, ID, listeners);
    }

    public static boolean isPlaying(String ID) {
        return playing.containsKey(ID);
    }

    public static void stop(String ID) {
        String id = ID.toLowerCase();
        if (playing.containsKey(id)) {
            Sequencer sequencer = playing.get(id);
            try {
                sequencer.getReceiver().close();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
            sequencer.stop();
            sequencer.close();
            playing.remove(id);
        }
    }

    private static byte bytePercussion(Integer patch) {
        if (patch == null) {
            return 0;
        }
        int i = patch - 33;
        if (i < 0 || i >= percussion.length) {
            return 1;
        }
        return (byte)percussion[i];
    }

    private static byte byteInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return (byte)instruments[patch];
    }

    public static Sound patchToPercussion(int patch) {
        return Instrument.fromByte(MidiUtil.bytePercussion(patch)).getSound();
    }

    public static Sound patchToInstrument(int patch) {
        return Instrument.fromByte(MidiUtil.byteInstrument(patch)).getSound();
    }
}

