/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;

public class Collect {
    public static String[] toStringArray(Object[] array) {
        String[] strings = new String[array.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = array[i].toString();
            ++i;
        }
        return strings;
    }

    public static String[] toFriendlyStringArray(Object[] array) {
        String[] strings = new String[array.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = array[i].toString().toLowerCase().replace("_", " ");
            ++i;
        }
        return strings;
    }

    @SafeVarargs
    public static <T> T[] asArray(T ... objects) {
        return objects;
    }

    public static <T> T[] newArray(Class<?> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static String[] asSkriptProperty(String property, String fromType) {
        return Collect.asArray("[the] " + property + " of %" + fromType + "%", "%" + fromType + "%'[s] " + property);
    }

    public static <T> String toString(T[] array) {
        return Collect.toString(array, ',');
    }

    public static <T> String toString(T[] array, char separator) {
        return Collect.toString(array, separator, true);
    }

    public static <T> String toString(T[] array, char separator, boolean spaces) {
        String SEPARATOR;
        String string = SEPARATOR = spaces ? " " : "";
        if (array == null) {
            return "null";
        }
        int max = array.length - 1;
        if (max == -1) {
            return "";
        }
        String b = "";
        int i = 0;
        while (true) {
            b = String.valueOf(b) + String.valueOf(array[i]);
            if (i == max) {
                return b;
            }
            b = String.valueOf(b) + separator + SEPARATOR;
            ++i;
        }
    }

    public static String getPaths(Collection<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String s : list) {
            builder.append(s).append(".");
        }
        return builder.toString().substring(0, builder.length() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String textPart(InputStream is) {
        if (is == null) {
            return "";
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (Scanner s = new Scanner(is).useDelimiter("\\A");){
            return s.hasNext() ? s.next() : "";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static ArrayList<File> getListFiles(File root, FilenameFilter filter, ArrayList<File> toAdd) {
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                toAdd.addAll(Collect.getListFiles(f, filter, toAdd));
            } else if (filter.accept(f, f.getName())) {
                toAdd.add(f);
            }
            ++n2;
        }
        return toAdd;
    }

    public static File[] getFiles(File root, FilenameFilter filter) {
        ArrayList<File> files = Collect.getListFiles(root, filter, new ArrayList<File>());
        return files.toArray(new File[files.size()]);
    }

    public static File[] getFiles(File root) {
        return Collect.getFiles(root, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }
}

