/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.skript;

import ch.njol.skript.Skript;
import com.w00tmast3r.skquery.elements.expressions.ExprCustomExpression;
import com.w00tmast3r.skquery.elements.expressions.ExprCustomPropertyExpression;
import com.w00tmast3r.skquery.skript.SerializableDefinitions;
import com.w00tmast3r.skquery.util.Collect;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SkqFileRegister {
    public static final Pattern COMMENT = Pattern.compile("--.*");
    public static final Pattern BL_TSTRUCT = Pattern.compile("define structure \"(.*)\"");
    public static final Pattern BL_END_TSTRUCT = Pattern.compile("end structure");
    public static final Pattern D_EFFECT = Pattern.compile("declare effect \"(.*)\"");
    public static final Pattern D_EXPRESSION = Pattern.compile("declare expression \"(.*)\"");
    public static final Pattern D_TYPED_EXPRESSION = Pattern.compile("declare expression \"(.*)\" as \"(.*)\"");
    public static final Pattern D_LEXPRESSION = Pattern.compile("declare loopable expression \"(.*)\"");
    public static final Pattern D_TYPED_LEXPRESSION = Pattern.compile("declare loopable expression \"(.*)\" as \"(.*)\"");
    public static final Pattern D_PROPERTY = Pattern.compile("declare property \"(.*)\" for \"(.*)\"");
    public static final Pattern D_TYPED_PROPERTY = Pattern.compile("declare property \"(.*)\" as \"(.*)\" for \"(.*)\"");
    public static final Pattern D_LPROPERTY = Pattern.compile("declare loopable property \"(.*)\" for \"(.*)\"");
    public static final Pattern D_TYPED_LPROPERTY = Pattern.compile("declare loopable property \"(.*)\" as \"(.*)\" for \"(.*)\"");
    public static final Pattern B_PROPERTY = Pattern.compile("bind property \"(.*)\"");
    public static final Pattern B_TYPED_PROPERTY = Pattern.compile("bind property \"(.*)\" as \"(.*)\"");
    public static final Pattern B_LPROPERTY = Pattern.compile("bind loopable property \"(.*)\"");
    public static final Pattern B_TYPED_LPROPERTY = Pattern.compile("bind loopable property \"(.*)\" as \"(.*)\"");

    public static void load() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".skq") && !name.startsWith("-");
            }
        };
        File[] fileArray = Collect.getFiles(new File(String.valueOf(Skript.getInstance().getDataFolder().getAbsolutePath()) + File.separator + "scripts"), filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block31: {
                File f = fileArray[n2];
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(f));
                    String cTStruct = null;
                    SerializableDefinitions definitions = new SerializableDefinitions();
                    while (reader.ready()) {
                        Matcher currentMatcher;
                        String line = reader.readLine().trim();
                        if (line.isEmpty()) continue;
                        if (cTStruct != null) {
                            if (BL_END_TSTRUCT.matcher(line).matches()) {
                                cTStruct = null;
                                continue;
                            }
                            currentMatcher = B_TYPED_PROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.bindProperty(cTStruct, currentMatcher.group(1), Class.forName(currentMatcher.group(2), false, SkqFileRegister.class.getClassLoader()), false);
                                continue;
                            }
                            currentMatcher = B_PROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.bindProperty(cTStruct, currentMatcher.group(1), Object.class, false);
                                continue;
                            }
                            currentMatcher = B_TYPED_LPROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.bindProperty(cTStruct, currentMatcher.group(1), Class.forName(currentMatcher.group(2), false, SkqFileRegister.class.getClassLoader()), true);
                                continue;
                            }
                            currentMatcher = B_LPROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.bindProperty(cTStruct, currentMatcher.group(1), Object.class, true);
                                continue;
                            }
                            if (COMMENT.matcher(line).matches()) continue;
                            Skript.error((String)("Strange syntax error in line: " + line));
                        } else {
                            currentMatcher = BL_TSTRUCT.matcher(line);
                            if (currentMatcher.matches()) {
                                cTStruct = currentMatcher.group(1);
                                definitions.declareStructure(cTStruct);
                                continue;
                            }
                            currentMatcher = D_EFFECT.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareEffect(currentMatcher.group(1));
                                continue;
                            }
                            currentMatcher = D_TYPED_EXPRESSION.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareExpression(currentMatcher.group(1), currentMatcher.group(2), false);
                                continue;
                            }
                            currentMatcher = D_EXPRESSION.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareExpression(currentMatcher.group(1), Object.class, false);
                                continue;
                            }
                            currentMatcher = D_TYPED_LEXPRESSION.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareExpression(currentMatcher.group(1), currentMatcher.group(2), true);
                                continue;
                            }
                            currentMatcher = D_LEXPRESSION.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareExpression(currentMatcher.group(1), Object.class, true);
                                continue;
                            }
                            currentMatcher = D_TYPED_PROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareProperty(currentMatcher.group(3), currentMatcher.group(1), currentMatcher.group(2), false);
                                continue;
                            }
                            currentMatcher = D_PROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareProperty(currentMatcher.group(2), currentMatcher.group(1), Object.class, false);
                                continue;
                            }
                            currentMatcher = D_TYPED_LPROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareProperty(currentMatcher.group(3), currentMatcher.group(1), currentMatcher.group(2), true);
                                continue;
                            }
                            currentMatcher = D_LPROPERTY.matcher(line);
                            if (currentMatcher.matches()) {
                                definitions.declareProperty(currentMatcher.group(2), currentMatcher.group(1), Object.class, true);
                                continue;
                            }
                            if (COMMENT.matcher(line).matches()) continue;
                            Skript.error((String)("Strange syntax error in line: " + line));
                        }
                        break block31;
                    }
                    reader.close();
                    if (!f.renameTo(new File(String.valueOf(f.getParent()) + File.separator + "-" + f.getName()))) {
                        Skript.warning((String)("Failed to disable " + f.getName() + ". The file will still be be parsed when starting the server, even if it was not changed. Please insert a '-' before the file name to manually disable it."));
                    }
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(String.valueOf(f.getParent()) + File.separator + f.getName() + "c"))));){
                        out.writeObject(definitions);
                        out.flush();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        SkqFileRegister.readCompiledFiles();
        SkqFileRegister.register();
    }

    private static void readCompiledFiles() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".skqc");
            }
        };
        File[] fileArray = Collect.getFiles(new File(String.valueOf(Skript.getInstance().getDataFolder().getAbsolutePath()) + File.separator + "scripts"), filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(f))));){
                    SerializableDefinitions definitions = (SerializableDefinitions)in.readObject();
                    ExprCustomExpression.addAll(definitions.getExpressionList().entrySet());
                    ExprCustomPropertyExpression.addAll(definitions.getPropertyList().entrySet());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private static void register() {
        ExprCustomExpression.register();
        ExprCustomPropertyExpression.register();
    }
}

