/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.event.Event;

@Name(value="Play Raw Sound")
@Description(value="Imitates the functionality of the /playsound command, without the ability to specify target players.")
@Examples(value={"on sneak toggle:;->play raw sound \"mob.bat.death\" at player with pitch 1 volume 10"})
@Patterns(value={"play [raw] sound %string/sound% at %locations% with pitch %number% [and] volume %number%"})
public class EffSound
extends Effect {
    private Expression<Object> sound;
    private Expression<Location> locations;
    private Expression<Number> pitch;
    private Expression<Number> volume;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sound = expressions[0];
        this.locations = expressions[1];
        this.pitch = expressions[2];
        this.volume = expressions[3];
        return true;
    }

    protected void execute(Event event) {
        String s = null;
        Object object = this.sound.getSingle(event);
        s = object instanceof Sound ? ((Sound)object).name() : (String)object;
        float p = ((Number)this.pitch.getSingle(event)).floatValue();
        float v = ((Number)this.volume.getSingle(event)).floatValue();
        if (s == null) {
            return;
        }
        Sound spigotSound = Sound.valueOf((String)s);
        Location[] locationArray = (Location[])this.locations.getArray(event);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location location = locationArray[n2];
            if (spigotSound != null) {
                location.getWorld().playSound(location, spigotSound, v, p);
            } else {
                location.getWorld().playSound(location, s, v, p);
            }
            ++n2;
        }
    }

    public String toString(Event event, boolean debug) {
        return "sound " + this.sound.toString(event, debug);
    }
}

