/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

@Name(value="Leash Entities")
@Description(value="Cause multiple entities to leash other entities.")
@Examples(value={"on click:;->make player leash clicked entity"})
@Patterns(value={"make %entities% (leash|lead) %livingentities%", "(leash|lead) %livingentities% to %entities%"})
public class EffLeash
extends Effect {
    private Expression<Entity> holders;
    private Expression<LivingEntity> targets;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.holders = expressions[matchedPattern];
        this.targets = expressions[1 - matchedPattern];
        return true;
    }

    protected void execute(Event event) {
        Entity[] entityArray = (Entity[])this.holders.getArray(event);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            LivingEntity[] livingEntityArray = (LivingEntity[])this.targets.getArray(event);
            int n3 = livingEntityArray.length;
            int n4 = 0;
            while (n4 < n3) {
                LivingEntity living = livingEntityArray[n4];
                living.setLeashHolder(entity);
                ++n4;
            }
            ++n2;
        }
    }

    public String toString(Event event, boolean debug) {
        return "leash " + this.targets.toString(event, debug) + " to " + this.holders.toString(event, debug);
    }
}

