/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;

@Name(value="Launch Fireworks")
@Description(value="Launch a firework with any number of firework effects at a given location and flight duration. Use (../expressions/(ExprFireworkEffect)this expression) to create firework effects.")
@Examples(value={"on death:;->launch creeper firework colored red at victim timed 1"})
@Patterns(value={"(launch|deploy) %fireworkeffects% at %locations% (with duration|timed) %number%"})
public class EffLaunchFirework
extends Effect {
    private Expression<FireworkEffect> effects;
    private Expression<Location> locations;
    private Expression<Number> lifetime;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.effects = expressions[0];
        this.locations = expressions[1];
        this.lifetime = expressions[2];
        return true;
    }

    protected void execute(Event event) {
        Number power = (Number)this.lifetime.getSingle(event);
        if (power == null) {
            return;
        }
        Location[] locationArray = (Location[])this.locations.getAll(event);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location location = locationArray[n2];
            Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
            FireworkMeta meta = firework.getFireworkMeta();
            meta.setPower(power.intValue());
            meta.addEffects((FireworkEffect[])this.effects.getArray(event));
            firework.setFireworkMeta(meta);
            ++n2;
        }
    }

    public String toString(Event event, boolean debug) {
        return "launch firework effects " + this.effects.toString(event, debug) + " at " + this.locations.toString(event, debug);
    }
}

