/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Escape Lines")
@Description(value="Skip the execution of a certain number of lines.")
@Examples(value={"on script load:;->escape 1;->stop;->message \"Stop avoided!\" to console"})
@Patterns(value={"escape %number% [(level[s]|line[s])]"})
public class EffEscape
extends Effect {
    private Expression<Number> escape;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.escape = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        throw new UnsupportedOperationException();
    }

    protected TriggerItem walk(Event event) {
        this.debug(event, false);
        Number lines = (Number)this.escape.getSingle(event);
        if (lines == null) {
            return null;
        }
        TriggerItem item = this.getNext();
        int i = 0;
        while (i < lines.intValue()) {
            if (item == null) {
                return null;
            }
            item = item.getNext();
            ++i;
        }
        return item;
    }

    public String toString(Event event, boolean debug) {
        return "escape " + this.escape.toString(event, debug);
    }
}

