/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Client Block")
@Description(value="Make a player see a block as another type of block. If the client recieves an update to the block, it will revert.")
@Examples(value={"on click:;->make player see clicked block as air"})
@Patterns(value={"make %players% see %blocks% as %itemtype%"})
public class EffClientBlock
extends Effect {
    private Expression<Player> players;
    private Expression<ItemType> item;
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = expressions[0];
        this.blocks = expressions[1];
        this.item = expressions[2];
        return true;
    }

    protected void execute(Event event) {
        ItemType type = (ItemType)this.item.getSingle(event);
        if (type == null) {
            return;
        }
        ItemStack itemstack = type.getRandom();
        Material material = itemstack.getType();
        if (!material.isBlock()) {
            return;
        }
        for (Player player : (Player[])this.players.getArray(event)) {
            for (Block block : (Block[])this.blocks.getArray(event)) {
                player.sendBlockChange(block.getLocation(), material, (byte)itemstack.getDurability());
            }
        }
    }

    public String toString(Event event, boolean debug) {
        return "client block to " + this.players.toString(event, debug) + " changing to " + this.item.toString(event, debug);
    }
}

