/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Branch")
@Description(value="Execute the following code X times. Useful for testing probabilities without requiring a loop and indentation.")
@Examples(value={"on script load:;->branch 10;->message \"This message will pop up 10 times\" to console"})
@Patterns(value={"branch %number%"})
public class EffBranch
extends Effect {
    private Expression<Number> branch;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.branch = expressions[0];
        return true;
    }

    protected void execute(Event event) {
        throw new UnsupportedOperationException();
    }

    protected TriggerItem walk(Event event) {
        this.debug(event, false);
        Number jumps = (Number)this.branch.getSingle(event);
        if (jumps == null) {
            return null;
        }
        for (int i = 0; i < jumps.intValue(); ++i) {
            TriggerItem.walk((TriggerItem)this.getNext(), (Event)event);
        }
        return null;
    }

    public String toString(Event event, boolean debug) {
        return "branch " + this.branch.toString(event, debug);
    }
}

