/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;

@Name(value="Entity has Potion")
@Description(value="Checks whether or not an entity has a certain potion effect.")
@Patterns(value={"%livingentity% (has|have) %potioneffecttype%", "%livingentities% does(n't| not) (has|have) %potioneffecttype%"})
public class CondHasPotion
extends Condition {
    private Expression<LivingEntity> livingEntity;
    private Expression<PotionEffectType> potion;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.livingEntity = expressions[0];
        this.potion = expressions[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event event) {
        LivingEntity entity = (LivingEntity)this.livingEntity.getSingle(event);
        PotionEffectType effect = (PotionEffectType)this.potion.getSingle(event);
        return entity != null && effect != null && (this.isNegated() ? !entity.hasPotionEffect(effect) : entity.hasPotionEffect(effect));
    }

    public String toString(Event event, boolean debug) {
        return this.livingEntity.toString(event, debug) + " has potion " + this.potion.toString(event, debug);
    }
}

