/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Play Raw Sound")
@Description(value="Imitates the functionality of the /playsound command, without the ability to specify target players.")
@Examples(value={"on sneak toggle:;->play raw sound \"mob.bat.death\" at player with pitch 1 volume 10"})
@Patterns(value={"play raw sound %string% at %locations% with pitch %number% volume %number%"})
public class EffCustomSound
extends Effect {
    private Expression<String> sound;
    private Expression<Location> loc;
    private Expression<Number> pit;
    private Expression<Number> vol;

    protected void execute(Event event) {
        String s = (String)this.sound.getSingle(event);
        Location[] l = (Location[])this.loc.getAll(event);
        float p = ((Number)this.pit.getSingle(event)).floatValue();
        float v = ((Number)this.vol.getSingle(event)).floatValue();
        if (s == null || l == null) {
            return;
        }
        Location[] locationArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Location fl = locationArray[n2];
            try {
                Class<?> craftWorldClass = Reflection.getOBCClass("CraftWorld");
                Object worldServer = craftWorldClass.getMethod("getHandle", new Class[0]).invoke((Object)fl.getWorld(), new Object[0]);
                worldServer.getClass().getMethod("makeSound", Double.TYPE, Double.TYPE, Double.TYPE, String.class, Float.TYPE, Float.TYPE).invoke(worldServer, fl.getX(), fl.getY(), fl.getZ(), s, Float.valueOf(p), Float.valueOf(v));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public String toString(Event event, boolean b) {
        return "sound";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.sound = expressions[0];
        this.loc = expressions[1];
        this.pit = expressions[3];
        this.vol = expressions[2];
        return true;
    }
}

