/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Collect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Client Sign")
@Description(value="Cause a sign to have custom lines to certain viewers")
@Examples(value={"command /hidesign:;->trigger:;->->make all players see lines of targeted block as \"\", \"\", \"\", \"\""})
@Patterns(value={"make %players% see lines of %block% as %string%, %string%, %string%( and|,) %string%"})
public class EffClientSign
extends Effect {
    private Expression<String> line1;
    private Expression<String> line2;
    private Expression<String> line3;
    private Expression<String> line4;
    private Expression<Player> players;
    private Expression<Block> block;

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.players = expressions[0];
        this.block = expressions[1];
        this.line1 = expressions[2];
        this.line2 = expressions[3];
        this.line3 = expressions[4];
        this.line4 = expressions[5];
        return true;
    }

    protected void execute(Event event) {
        Block b = (Block)this.block.getSingle(event);
        if (b == null) {
            return;
        }
        String a1 = (String)this.line1.getSingle(event);
        String a2 = (String)this.line2.getSingle(event);
        String a3 = (String)this.line3.getSingle(event);
        String a4 = (String)this.line4.getSingle(event);
        Material material = b.getType();
        if (material == Material.SIGN_POST || material == Material.WALL_SIGN || material == Material.SIGN) {
            Player[] playerArray = (Player[])this.players.getArray(event);
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                player.sendSignChange(b.getLocation(), Collect.asArray(a1, a2, a3, a4));
                ++n2;
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "client sign";
    }
}

