/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="File existance")
@Description(value={"Checks whether or not a file at the defined path(s) exist."})
public class CondFileExistance
extends Condition {
    private Expression<String> files;
    private Expression<Boolean> check;

    static {
        Skript.registerCondition(CondFileExistance.class, (String[])new String[]{"file %string% (1\u00a6does|2\u00a6does(n't| not)) exist", "existance of [file] %string% is %boolean%"});
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.files = exprs[0];
        this.setNegated(parseResult.mark == 1);
        if (exprs.length > 1) {
            this.check = exprs[0];
        }
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "file existance" + this.files != null ? this.files.toString(event, debug) : "";
    }

    public boolean check(Event event) {
        if (this.files == null) {
            return !this.isNegated();
        }
        Boolean negated = this.check != null ? ((Boolean)this.check.getSingle(event)).booleanValue() : this.isNegated();
        File file = new File((String)this.files.getSingle(event));
        return file.exists() ? negated : negated == false;
    }
}

