/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.skript;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import java.util.HashMap;
import java.util.Map;

public class EnumClassInfo<E extends Enum<E>> {
    private final Class<E> enumType;
    private final String codeName;
    private final ClassInfo<E> classInfo;
    private final HashMap<String, String> synonyms = new HashMap();

    private EnumClassInfo(Class<E> enumType, String codeName) {
        this.enumType = enumType;
        this.codeName = codeName;
        this.classInfo = new ClassInfo(enumType, codeName);
    }

    public static <E extends Enum<E>> EnumClassInfo<E> create(Class<E> enumType, String codeName) {
        return new EnumClassInfo<E>(enumType, codeName);
    }

    public EnumClassInfo<E> addSynonym(String regex, String actualValue) {
        this.synonyms.put(regex, actualValue);
        return this;
    }

    public EnumClassInfo<E> after(String ... after) {
        this.classInfo.after(after);
        return this;
    }

    public EnumClassInfo<E> before(String ... before) {
        this.classInfo.before(before);
        return this;
    }

    public void register() {
        if (Classes.getExactClassInfo(this.enumType) == null) {
            Classes.registerClass((ClassInfo)this.classInfo.user(new String[]{String.valueOf(this.codeName) + "s?"}).parser(new Parser<E>(){

                public E parse(String s, ParseContext parseContext) {
                    if (s.startsWith(String.valueOf(EnumClassInfo.this.codeName) + ":")) {
                        s = s.substring(EnumClassInfo.this.codeName.length() + 1, s.length());
                    }
                    try {
                        for (Map.Entry p : EnumClassInfo.this.synonyms.entrySet()) {
                            if (!s.matches((String)p.getKey())) continue;
                            return Enum.valueOf(EnumClassInfo.this.enumType, (String)p.getValue());
                        }
                        return Enum.valueOf(EnumClassInfo.this.enumType, s.replace(" ", "_").toUpperCase().trim());
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }

                public String toString(E e, int i) {
                    return ((Enum)e).toString();
                }

                public String toVariableNameString(E e) {
                    return String.valueOf(EnumClassInfo.this.codeName) + ':' + ((Enum)e).toString();
                }

                public String getVariableNamePattern() {
                    return String.valueOf(EnumClassInfo.this.codeName) + ":.+";
                }
            }).serializer((Serializer)new EnumSerializer(this.enumType)));
        }
    }
}

