/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.lang.SkriptParser;
import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.elements.effects.base.OptionsPragma;
import com.w00tmast3r.skquery.util.CancellableBukkitTask;
import com.w00tmast3r.skquery.util.Collect;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;

@Name(value="Developer Mode Option")
@Description(value="Enable the developer mode pragma to auto reload a script as it changes.  This must be placed under the script-local options.")
@Examples(value={"script options:;->$ developer mode"})
@Patterns(value={"$ developer mode"})
public class EffOptionDeveloperMode
extends OptionsPragma {
    private long lastUpdated;

    @Override
    protected void register(final File executingScript, SkriptParser.ParseResult parseResult) {
        this.lastUpdated = executingScript.lastModified();
        CancellableBukkitTask task = new CancellableBukkitTask(){

            @Override
            public void run() {
                if (EffOptionDeveloperMode.this.lastUpdated != executingScript.lastModified()) {
                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&6skQuery&7] &r(Dev Mode) Starting auto-reload of script '" + executingScript.getName() + "'")));
                    try {
                        Method unloadScript = ScriptLoader.class.getDeclaredMethod("unloadScript", File.class);
                        unloadScript.setAccessible(true);
                        unloadScript.invoke(null, executingScript);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    List configs = ScriptLoader.loadStructures((File[])Collect.asArray(executingScript));
                    ScriptLoader.loadScripts((List)configs);
                    Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)("&7[&6skQuery&7] &r(Dev Mode) '" + executingScript.getName() + "' has been reloaded.")));
                    this.cancel();
                }
            }
        };
        task.setTaskId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)SkQuery.getInstance(), (Runnable)task, 0L, 100L));
    }
}

