/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.event.Event;

@Name(value="Is Prime")
@Description(value="Checks whether or not a number is prime.")
@Patterns(value={"%number% is prime", "%number% is not prime"})
public class CondIsPrime
extends Condition {
    private Expression<Number> num;

    public boolean check(Event event) {
        return this.num.check(event, (Checker)new Checker<Number>(){

            public boolean check(Number in) {
                return CondIsPrime.isPrime(in.intValue());
            }
        }, this.isNegated());
    }

    public String toString(Event event, boolean b) {
        return "is prime";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.num = expressions[0];
        this.setNegated(i == 1);
        return true;
    }

    public static boolean isPrime(int n) {
        if (n % 2 == 0) {
            return false;
        }
        int i = 3;
        while (i * i <= n) {
            if (n % i == 0) {
                return false;
            }
            i += 2;
        }
        return true;
    }
}

