/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.util.Collect;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.PlayerInventory;

@UsePropertyPatterns
@PropertyFrom(value="players")
@PropertyTo(value="(current|selected) hotbar slot [id]")
public class ExprHotbarSlot
extends SimplePropertyExpression<Player, Number> {
    protected String getPropertyName() {
        return "selected hotbar slot";
    }

    public Number convert(Player player) {
        return player.getInventory().getHeldItemSlot();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Integer n = delta[0] == null ? (Number)0 : (Number)((Number)delta[0]);
        PlayerInventory i = ((Player)this.getExpr().getSingle(e)).getInventory();
        switch (mode) {
            case ADD: {
                i.setHeldItemSlot((n + i.getHeldItemSlot()) % 9);
                break;
            }
            case SET: {
                i.setHeldItemSlot(((Number)n).intValue());
                break;
            }
            case REMOVE: {
                i.setHeldItemSlot((n - i.getHeldItemSlot()) % 9);
                break;
            }
            case RESET: {
                i.setHeldItemSlot(0);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.RESET ? Collect.asArray(Number.class) : null;
    }
}

