/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Pathfind")
@Description(value="Invoke the entity pathfinder. Allows entities to pathfind to a location unless they are distracted. Not all entities have pathfinders.")
@Examples(value={"on click on cow:;->while clicked entity exists:;->->make clicked entity pathfind to player with speed;->->wait 1 tick"})
@Patterns(value={"make %livingentities% pathfind to %location% (with|at) speed %number%"})
public class EffPathfind
extends Effect {
    private Expression<LivingEntity> entity;
    private Expression<Location> loc;
    private Expression<Number> speed;

    protected void execute(Event event) {
        Location l = (Location)this.loc.getSingle(event);
        Number s = (Number)this.speed.getSingle(event);
        if (l == null || s == null) {
            return;
        }
        LivingEntity[] livingEntityArray = (LivingEntity[])this.entity.getAll(event);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity e = livingEntityArray[n2];
            if (!(e instanceof Player)) {
                try {
                    Object entityInsentient = Reflection.obcClass("entity.CraftLivingEntity").getMethod("getHandle", new Class[0]).invoke((Object)e, new Object[0]);
                    Object navigation = Reflection.nmsClass("EntityInsentient").getMethod("getNavigation", new Class[0]).invoke(entityInsentient, new Object[0]);
                    navigation.getClass().getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).invoke(navigation, l.getX(), l.getY(), l.getZ(), s.doubleValue());
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public String toString(Event event, boolean b) {
        return "pathfind";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expressions[0];
        this.loc = expressions[1];
        this.speed = expressions[2];
        return true;
    }
}

