/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffectType;

@Name(value="Has Potion")
@Description(value="Checks whether or not an entity has a certain potion effect on it.")
@Patterns(value={"%livingentities% has %potioneffecttype%", "%livingentities% does(n't| not) have %potioneffecttype%"})
public class CondHasPotion
extends Condition {
    private Expression<LivingEntity> entity;
    private Expression<PotionEffectType> eff;

    public boolean check(Event event) {
        LivingEntity e = (LivingEntity)this.entity.getSingle(event);
        PotionEffectType t = (PotionEffectType)this.eff.getSingle(event);
        return e != null && t != null && (this.isNegated() ? !e.hasPotionEffect(t) : e.hasPotionEffect(t));
    }

    public String toString(Event event, boolean b) {
        return "can has potion";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.entity = expressions[0];
        this.eff = expressions[1];
        this.setNegated(i == 1);
        return true;
    }
}

