/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

public class ScriptCredentials {
    public static String currentPool = "default";
    private static HashMap<File, ScriptCredentials> credentials = new HashMap();
    private String url = null;
    private String username = null;
    private String password = null;
    private HashMap<String, Connection> connection = null;

    private ScriptCredentials() {
    }

    public static void setURL(File script, String url) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.url = url;
        sc.validate();
    }

    public static void setUsername(File script, String username) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.username = username;
        sc.validate();
    }

    public static void setPassword(File script, String password) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.password = password;
        sc.validate();
    }

    public Connection getConnection() {
        return this.getConnection("default");
    }

    public Connection getConnection(String pool) {
        return this.connection.get(pool);
    }

    public static ScriptCredentials get(File script) {
        return ScriptCredentials.get(script, "default");
    }

    public static ScriptCredentials get(File script, String pool) {
        if (!credentials.containsKey(script)) {
            credentials.put(script, new ScriptCredentials());
        }
        ScriptCredentials c = credentials.get(script);
        try {
            if (c.connection != null && !c.connection.containsKey(pool) && !c.connection.get(pool).isValid(1)) {
                c.validate(pool);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return c;
    }

    public static void clear() {
        for (ScriptCredentials sc : credentials.values()) {
            if (sc.connection == null) continue;
            try {
                for (Connection connection : sc.connection.values()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void validate() {
        if (this.url != null && this.username != null && this.password != null) {
            this.connection = new HashMap();
            this.validate("default");
        }
    }

    private void validate(String pool) {
        if (this.url != null && this.username != null && this.password != null) {
            try {
                this.connection.put(pool, DriverManager.getConnection(this.url, this.username, this.password));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

