/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.custom.note;

import com.w00tmast3r.skquery.util.custom.note.NoteBlockReceiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class MidiUtil {
    private static HashMap<String, NoteBlockReceiver> playing = new HashMap();
    private static final int[] instruments;

    static {
        int[] nArray = new int[128];
        nArray[7] = 5;
        nArray[8] = 6;
        nArray[23] = 5;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        nArray[28] = 5;
        nArray[29] = 5;
        nArray[30] = 5;
        nArray[31] = 5;
        nArray[32] = 6;
        nArray[33] = 6;
        nArray[34] = 6;
        nArray[35] = 6;
        nArray[36] = 6;
        nArray[37] = 6;
        nArray[38] = 6;
        nArray[39] = 6;
        nArray[40] = 5;
        nArray[41] = 5;
        nArray[42] = 5;
        nArray[43] = 5;
        nArray[44] = 5;
        nArray[45] = 5;
        nArray[46] = 5;
        nArray[47] = 2;
        nArray[48] = 5;
        nArray[49] = 5;
        nArray[50] = 5;
        nArray[51] = 5;
        nArray[112] = 1;
        nArray[113] = 1;
        nArray[114] = 1;
        nArray[115] = 3;
        nArray[116] = 1;
        nArray[117] = 1;
        nArray[118] = 1;
        nArray[119] = 5;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        nArray[123] = 1;
        nArray[124] = 1;
        nArray[125] = 2;
        nArray[126] = 4;
        nArray[127] = 3;
        instruments = nArray;
    }

    private static void playMidi(Sequence seq, float tempo, Set<Player> listeners, String ID) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        Sequencer sequencer = MidiSystem.getSequencer(false);
        sequencer.setSequence(seq);
        sequencer.open();
        sequencer.setTempoFactor(tempo);
        NoteBlockReceiver noteblockRecv = new NoteBlockReceiver(listeners);
        sequencer.getTransmitter().setReceiver(noteblockRecv);
        sequencer.start();
        playing.put(ID, noteblockRecv);
    }

    public static void dump() {
        playing.clear();
    }

    public static void playMidi(File file, float tempo, Set<Player> listeners, String ID) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        MidiUtil.playMidi(MidiSystem.getSequence(file), tempo, listeners, ID);
    }

    public static void playMidi(InputStream stream, float tempo, Set<Player> listeners, String ID) throws InvalidMidiDataException, IOException, MidiUnavailableException {
        MidiUtil.playMidi(MidiSystem.getSequence(stream), tempo, listeners, ID);
    }

    public static boolean playMidiQuietly(File file, float tempo, Set<Player> listeners, String ID) {
        try {
            MidiUtil.playMidi(file, tempo, listeners, ID);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean playMidiQuietly(InputStream stream, float tempo, Set<Player> listeners, String ID) {
        try {
            MidiUtil.playMidi(stream, tempo, listeners, ID);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean playMidiQuietly(File file, Set<Player> listeners, String ID) {
        return MidiUtil.playMidiQuietly(file, 1.0f, listeners, ID);
    }

    public static boolean playMidiQuietly(InputStream stream, Set<Player> listeners, String ID) {
        return MidiUtil.playMidiQuietly(stream, 1.0f, listeners, ID);
    }

    public static boolean isPlaying(String ID) {
        return playing.containsKey(ID);
    }

    public static void stopMidi(String ID) {
        if (playing.containsKey(ID)) {
            playing.get(ID).close();
            playing.remove(ID);
        }
    }

    public static Sound patchToInstrument(int patch) {
        switch (instruments[patch]) {
            case 1: {
                return Sound.BLOCK_NOTE_HAT;
            }
            case 2: {
                return Sound.BLOCK_NOTE_SNARE;
            }
            case 3: {
                return Sound.BLOCK_NOTE_HARP;
            }
            case 4: {
                return Sound.BLOCK_NOTE_BASEDRUM;
            }
            case 5: {
                return Sound.BLOCK_NOTE_PLING;
            }
            case 6: {
                return Sound.BLOCK_NOTE_BASS;
            }
        }
        return Sound.BLOCK_NOTE_BASS;
    }
}

