/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.custom.menus.v2_.FormattedSlotManager;
import com.w00tmast3r.skquery.util.custom.menus.v2_.SlotRule;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Name(value="Format Inventory Slot")
@Description(value="Formats a slot in the player's open inventory to do certain actions. This should be done directly after showing an inventory to the player.")
@Examples(value={"command /construct:;->trigger:;->->open chest with 1 rows named \"&4My first test menu\" to player;->->format slot 0 of player with 5 of steak named \"Item 1\" to close then run \"say The first item was clicked! Menu Closed!\";->->format slot 2 of player with fire named \"Close Menu\" with lore \"I will close this menu.||Nothing more, nothing less.\" to close"})
@Patterns(value={"format slot %number% of %players% with %itemstack% to close then run %string/lambda%", "format slot %number% of %players% with %itemstack% to run %string/lambda%", "format slot %number% of %players% with %itemstack% to close", "format slot %number% of %players% with %itemstack% to (be|act) unstealable", "unformat slot %number% of %players%"})
public class EffAddFormatSlot
extends Effect {
    private Expression<Number> slot;
    private Expression<Player> targets;
    private Expression<ItemStack> item;
    private Expression<?> callback;
    private int action;

    protected void execute(Event event) {
        Player p;
        int n;
        int n2;
        Player[] playerArray;
        SlotRule toClone;
        Number s = (Number)this.slot.getSingle(event);
        ItemStack i = null;
        if (s == null) {
            return;
        }
        switch (this.action) {
            case 0: {
                Object c = this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, true);
                break;
            }
            case 1: {
                Object c = this.callback.getSingle(event);
                i = (ItemStack)this.item.getSingle(event);
                if (c == null) {
                    return;
                }
                toClone = new SlotRule(c, false);
                break;
            }
            case 2: {
                i = (ItemStack)this.item.getSingle(event);
                if (i == null) {
                    return;
                }
                toClone = new SlotRule(null, true);
                break;
            }
            case 3: {
                i = (ItemStack)this.item.getSingle(event);
                toClone = new SlotRule(null, false);
                break;
            }
            case 4: {
                Player[] playerArray2 = (Player[])this.targets.getAll(event);
                int n3 = playerArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Player p2 = playerArray2[n4];
                    FormattedSlotManager.removeRule(p2, s.intValue());
                    ++n4;
                }
                return;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (i != null) {
            playerArray = (Player[])this.targets.getAll(event);
            n2 = playerArray.length;
            n = 0;
            while (n < n2) {
                p = playerArray[n];
                if (p.getOpenInventory().getType() != InventoryType.CRAFTING) {
                    p.getOpenInventory().setItem(s.intValue(), i);
                }
                ++n;
            }
        }
        playerArray = (Player[])this.targets.getAll(event);
        n2 = playerArray.length;
        n = 0;
        while (n < n2) {
            p = playerArray[n];
            if (p.getOpenInventory().getType() != InventoryType.CRAFTING) {
                FormattedSlotManager.addRule(event, p, s.intValue(), toClone.getCopy());
            }
            ++n;
        }
    }

    public String toString(Event event, boolean b) {
        return "format";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.slot = expressions[0];
        this.targets = expressions[1];
        if (i <= 3) {
            this.item = expressions[2];
        }
        if (i <= 1) {
            this.callback = expressions[3];
        }
        this.action = i;
        return true;
    }
}

