/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.custom.note.MidiUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Play MIDI")
@Description(value="Plays a file with the extention .mid to a player.")
@Examples(value={"on join:;->play midi \"login\" to player"})
@Patterns(value={"play midi from [(web[site]|link)] %string% to %players% [at [tempo] %-number%]"})
public class EffMIDIWeb
extends Effect {
    private Expression<String> link;
    private Expression<Player> players;
    private Expression<Number> tempo;

    protected void execute(Event event) {
        String m = (String)this.link.getSingle(event);
        if (m == null) {
            return;
        }
        HashSet<Player> pList = new HashSet<Player>();
        Collections.addAll(pList, (Player[])this.players.getAll(event));
        Float tempoFinal = Float.valueOf(1.0f);
        if (this.tempo != null) {
            Number num = (Number)this.tempo.getSingle(event);
            tempoFinal = Float.valueOf(num.floatValue());
        }
        try {
            InputStream input = new URL((String)this.link.getSingle(event)).openStream();
            try {
                MidiUtil.playMidi(input, tempoFinal.floatValue(), pList);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
                return;
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                return;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public String toString(Event event, boolean b) {
        return "midi";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.link = expressions[0];
        this.players = expressions[1];
        return true;
    }
}

