/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.custom.note.MidiUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@Name(value="Play MIDI")
@Description(value="Plays a file with the extention .mid to a player.")
@Examples(value={"on join:;->play midi \"login\" to player"})
@Patterns(value={"play midi %string% to %players% [at [tempo] %-number%]"})
public class EffMIDI
extends Effect {
    private Expression<String> midi;
    private Expression<Player> players;
    private Expression<Number> tempo;

    protected void execute(Event event) {
        String m = (String)this.midi.getSingle(event);
        if (m == null) {
            return;
        }
        File f = new File(String.valueOf(Skript.getInstance().getDataFolder().getAbsolutePath()) + File.separator + "scripts" + File.separator + m + ".mid");
        HashSet<Player> pList = new HashSet<Player>();
        Float tempoFinal = Float.valueOf(1.0f);
        if (this.tempo != null) {
            Number num = (Number)this.tempo.getSingle(event);
            tempoFinal = Float.valueOf(num.floatValue());
        }
        if (f.exists()) {
            Collections.addAll(pList, (Player[])this.players.getAll(event));
            try {
                MidiUtil.playMidi(f, tempoFinal.floatValue(), pList);
            }
            catch (InvalidMidiDataException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getLogger().warning("Could not find midi file " + m + ".mid in the scripts folder");
        }
    }

    public String toString(Event event, boolean b) {
        return "midi";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.midi = expressions[0];
        this.players = expressions[1];
        return true;
    }
}

