/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.elements.events.bukkit.AttachedTabCompleteEvent;
import com.w00tmast3r.skquery.util.Collect;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Patterns(value={"[tab] (completions|suggestions)"})
public class ExprTabCompletions
extends SimpleExpression<String> {
    protected String[] get(Event e) {
        List<String> completions = ((AttachedTabCompleteEvent)e).getResult();
        return completions.toArray(new String[completions.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "tab results";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(AttachedTabCompleteEvent.class)) {
            Skript.error((String)"Tab completers can only be accessed from tab complete events.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD) {
            return Collect.asArray(String.class);
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        AttachedTabCompleteEvent event;
        String node = delta[0] == null ? "" : (String)delta[0];
        if (node.startsWith((event = (AttachedTabCompleteEvent)e).getArgs()[event.getArgs().length - 1])) {
            event.getResult().add(node);
        }
    }
}

