/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.PropertyFrom;
import com.w00tmast3r.skquery.api.PropertyTo;
import com.w00tmast3r.skquery.api.UsePropertyPatterns;
import com.w00tmast3r.skquery.skript.PermissionsHandler;
import com.w00tmast3r.skquery.util.Collect;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionAttachment;
import org.eclipse.jdt.annotation.Nullable;

@UsePropertyPatterns
@PropertyFrom(value="players")
@PropertyTo(value="permissions")
public class ExprPlayerPermissions
extends SimpleExpression<String> {
    private Expression<Player> player;

    protected String[] get(Event event) {
        Player p = (Player)this.player.getSingle(event);
        if (p == null) {
            return null;
        }
        ArrayList permissions = new ArrayList();
        for (Map.Entry perm : PermissionsHandler.getPermissions(p).getPermissions().entrySet()) {
            if (!((Boolean)perm.getValue()).booleanValue()) continue;
            permissions.add(perm.getKey());
        }
        return permissions.toArray(new String[permissions.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "effective permissions";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!PermissionsHandler.isEnabled()) {
            Skript.error((String)"The skQuery Permissions Manager must be enabled from a script before using permissions features!");
            return false;
        }
        this.player = expressions[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return Collect.asArray(String[].class);
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        for (Player p : (Player[])this.player.getAll(e)) {
            PermissionAttachment perm = PermissionsHandler.getPermissions(p);
            for (Object s : delta) {
                perm.setPermission((String)s, mode == Changer.ChangeMode.ADD);
            }
        }
    }
}

