/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.maps.RenderTask;
import com.w00tmast3r.skquery.util.maps.SkriptMapRenderer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

@Name(value="Draw Text on Map")
@Description(value="Draws text on a map that has been run through ((EffManageMap)Manage Map). Omitting the position draws the text at 0, 0.")
@Examples(value={"draw \"Bacon Count: 17\" on map 0 starting from 16, 16"})
@Patterns(value={"draw %string% on [map] %number%", "draw %string% on [map] %number% [starting] from %number%, %number%"})
public class EffDrawText
extends Effect {
    private Expression<String> text;
    private Expression<Number> id;
    private Expression<Number> x;
    private Expression<Number> y;
    private boolean useCoordinates;

    protected void execute(Event event) {
        MapView mapView;
        final String i = (String)this.text.getSingle(event);
        Number n = (Number)this.id.getSingle(event);
        int xO = 0;
        int yO = 0;
        if (this.useCoordinates) {
            Number xC = (Number)this.x.getSingle(event);
            Number yC = (Number)this.y.getSingle(event);
            if (xC == null || yC == null) {
                return;
            }
            xO = xC.intValue();
            yO = yC.intValue();
        }
        if (n == null || i == null) {
            return;
        }
        short id = n.shortValue();
        final int fXO = xO;
        final int fYO = yO;
        try {
            mapView = Bukkit.getMap((short)id);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Map " + id + " has not been initialized yet!");
            return;
        }
        SkriptMapRenderer renderer = SkriptMapRenderer.getRenderer(mapView);
        if (renderer == null) {
            return;
        }
        renderer.update(new RenderTask(){

            @Override
            public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
                mapCanvas.drawText(fXO, fYO, (MapFont)MinecraftFont.Font, i);
            }
        });
    }

    public String toString(Event event, boolean b) {
        return "manage skript maps";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.text = expressions[0];
        this.id = expressions[1];
        boolean bl = this.useCoordinates = i == 1;
        if (this.useCoordinates) {
            this.x = expressions[2];
            this.y = expressions[3];
        }
        return true;
    }
}

