/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.CancellableBukkitTask;
import com.w00tmast3r.skquery.util.packet.particle.Particle;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.plugin.Plugin;

@Patterns(value={"trail projectile with %particle%"})
public class EffTrail
extends Effect {
    private Expression<Particle> particle;

    protected void execute(Event event) {
        final Particle p = (Particle)this.particle.getSingle(event);
        if (p == null) {
            return;
        }
        final ProjectileLaunchEvent e = (ProjectileLaunchEvent)event;
        CancellableBukkitTask task = new CancellableBukkitTask(){

            @Override
            public void run() {
                p.play(e.getEntity().getLocation(), Bukkit.getOnlinePlayers());
                if (!e.getEntity().isValid() || e.getEntity().isOnGround()) {
                    this.cancel();
                }
            }
        };
        task.setTaskId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)SkQuery.getInstance(), (Runnable)task, 0L, 1L));
    }

    public String toString(Event event, boolean b) {
        return "projectile trail";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent(ProjectileLaunchEvent.class)) {
            Skript.error((String)"Trailing can only be used in a shoot event", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.particle = expressions[0];
        return true;
    }
}

