/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;

@Name(value="Launch Fireworks")
@Description(value="Launch a firework with any number of firework effects at a given location and flight duration. Use ((ExprFireworkEffect)this expression) to create firework effects.")
@Patterns(value={"(launch|deploy) %fireworkeffects% at %locations% (with duration|timed) %number%"})
public class EffLaunch
extends Effect {
    private Expression<FireworkEffect> effects;
    private Expression<Location> loc;
    private Expression<Number> lifetime;

    protected void execute(Event event) {
        Number n = (Number)this.lifetime.getSingle(event);
        if (n == null) {
            return;
        }
        for (Location l : (Location[])this.loc.getAll(event)) {
            Firework firework = (Firework)l.getWorld().spawn(l, Firework.class);
            FireworkMeta fm = firework.getFireworkMeta();
            fm.setPower(n.intValue());
            fm.addEffects((FireworkEffect[])this.effects.getAll(event));
            firework.setFireworkMeta(fm);
        }
    }

    public String toString(Event event, boolean b) {
        return "launch launch";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.effects = expressions[0];
        this.loc = expressions[1];
        this.lifetime = expressions[2];
        return true;
    }
}

