/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.api.Dependency;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.ValuePair;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@Name(value="Server/Client Block")
@Description(value="Make a player see a block as another type of block. If the client recieves an update to the block, it will not revert like with ((EffClientBlock)).")
@Dependency(value={"ProtocolLib"})
@Patterns(value={"make %players% see %blocks% as %itemtype% permanently", "restore updates to %blocks% for %offlineplayers%", "restore all updates"})
public class EffKeepClientBlock
extends Effect {
    private Expression<Player> player;
    private Expression<OfflinePlayer> offlinePlayers;
    private Expression<Block> block;
    private Expression<ItemType> material;
    private int pattern;

    protected void execute(Event event) {
        if (this.pattern == 0) {
            ItemType m = (ItemType)this.material.getSingle(event);
            if (m == null) {
                return;
            }
            Material mat = m.getRandom().getType();
            if (!mat.isBlock()) {
                return;
            }
            for (Player p : (Player[])this.player.getAll(event)) {
                for (Block b : (Block[])this.block.getAll(event)) {
                    p.sendBlockChange(b.getLocation(), mat, (byte)m.getRandom().getDurability());
                    if (!PacketListeners.clientRenders.containsKey(b.getLocation())) {
                        PacketListeners.clientRenders.put(b.getLocation(), new HashMap());
                    }
                    ((HashMap)PacketListeners.clientRenders.get(b.getLocation())).put(p.getUniqueId(), new ValuePair<Material, Integer>(mat, Integer.valueOf(m.getRandom().getDurability())));
                }
            }
        } else if (this.pattern == 1) {
            for (OfflinePlayer p : (OfflinePlayer[])this.offlinePlayers.getAll(event)) {
                for (Block b : (Block[])this.block.getAll(event)) {
                    if (!PacketListeners.clientRenders.containsKey(b.getLocation())) continue;
                    ((HashMap)PacketListeners.clientRenders.get(b.getLocation())).remove(p.getUniqueId());
                    if (((HashMap)PacketListeners.clientRenders.get(b.getLocation())).size() == 0) {
                        PacketListeners.clientRenders.remove(b.getLocation());
                    }
                    if (!p.isOnline()) continue;
                    p.getPlayer().sendBlockChange(b.getLocation(), b.getType(), b.getData());
                }
            }
        } else {
            PacketListeners.clientRenders = new HashMap();
        }
    }

    public String toString(Event event, boolean b) {
        return "credits";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (i == 0) {
            this.player = expressions[0];
            this.block = expressions[1];
            this.material = expressions[2];
        } else if (i == 1) {
            this.block = expressions[0];
            this.offlinePlayers = expressions[1];
        }
        this.pattern = i;
        return true;
    }

    public static class PacketListeners
    implements Listener {
        private static boolean hasInitialized = false;
        private static HashMap<Location, HashMap<UUID, ValuePair<Material, Integer>>> clientRenders = new HashMap();

        static {
            if (!hasInitialized) {
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter(new PacketAdapter.AdapterParameteters().plugin((Plugin)SkQuery.getInstance()).serverSide().types(new PacketType[]{PacketType.Play.Server.BLOCK_CHANGE})){

                    public void onPacketSending(PacketEvent event) {
                        StructureModifier ints = event.getPacket().getIntegers();
                        Player p = event.getPlayer();
                        Location l = new Location(p.getWorld(), (double)((Integer)ints.read(0)).intValue(), (double)((Integer)ints.read(1)).intValue(), (double)((Integer)ints.read(2)).intValue());
                        if (clientRenders.containsKey(l) && ((HashMap)clientRenders.get(l)).containsKey(p.getUniqueId())) {
                            event.getPacket().getBlocks().write(0, ((ValuePair)((HashMap)clientRenders.get(l)).get(p.getUniqueId())).getFirstValue());
                            ints.write(3, ((ValuePair)((HashMap)clientRenders.get(l)).get(p.getUniqueId())).getSecondValue());
                        }
                    }
                });
            }
            hasInitialized = true;
        }
    }
}

