/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

@Name(value="Spawn Falling Block")
@Description(value="Summons falling blocks with modifiable properties.")
@Patterns(value={"spawn falling block of %itemtype% at %location%", "spawn damaging falling block of %itemtype% at %location%", "spawn undroppable falling block of %itemtype% at %location%", "spawn damaging undroppable falling block of %itemtype% at %location%", "spawn undroppable damaging falling block of %itemtype% at %location%"})
public class EffBlockFall
extends Effect {
    private Expression<ItemType> type;
    private Expression<Location> loc;
    boolean breaks;
    boolean damages;

    protected void execute(Event event) {
        ItemType t = (ItemType)this.type.getSingle(event);
        if (t == null) {
            return;
        }
        for (Location locs : (Location[])this.loc.getArray(event)) {
            for (ItemStack i : t.getAll()) {
                FallingBlock block = locs.getWorld().spawnFallingBlock(locs, i.getType(), (byte)i.getDurability());
                if (this.damages) {
                    try {
                        Object craftSand = Reflection.obcClass("entity.CraftFallingSand").getMethod("getHandle", new Class[0]).invoke((Object)block, new Object[0]);
                        craftSand.getClass().getMethod("a", Boolean.TYPE).invoke(craftSand, true);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.breaks) continue;
                block.setDropItem(false);
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "falling block";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.type = expressions[0];
        this.loc = expressions[1];
        this.damages = i == 1 || i == 3 || i == 4;
        this.breaks = i == 2 || i == 3 || i == 4;
        return true;
    }
}

