/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PlayerDisplayChanger {
    private static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final int WORKER_THREADS = 4;
    private ProtocolManager protocolManager;
    private ConcurrentMap<String, String> skinNames = Maps.newConcurrentMap();
    private ConcurrentMap<String, String> displayNames = Maps.newConcurrentMap();
    private Cache<String, String> profileCache = CacheBuilder.newBuilder().maximumSize(500).expireAfterWrite(4L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String name) throws Exception {
            return PlayerDisplayChanger.this.getProfileJson(name);
        }
    });

    public PlayerDisplayChanger(Plugin plugin) {
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.protocolManager.getAsynchronousManager().registerAsyncHandler((PacketListener)new PacketAdapter(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.NAMED_ENTITY_SPAWN, PacketType.Play.Server.ENTITY_EFFECT, PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.UPDATE_ATTRIBUTES, PacketType.Play.Server.ATTACH_ENTITY, PacketType.Play.Server.BED}){

            public void onPacketSending(PacketEvent event) {
                if (event.getPacketType() != PacketType.Play.Server.NAMED_ENTITY_SPAWN) {
                    return;
                }
                Player toDisplay = (Player)event.getPacket().getEntityModifier(event).read(0);
                String skinName = (String)PlayerDisplayChanger.this.skinNames.get(toDisplay.getName());
                String displayName = (String)PlayerDisplayChanger.this.displayNames.get(toDisplay.getName());
                if (skinName == null && displayName == null) {
                    return;
                }
                StructureModifier profiles = event.getPacket().getGameProfiles();
                WrappedGameProfile original = (WrappedGameProfile)profiles.read(0);
                WrappedGameProfile result = new WrappedGameProfile(PlayerDisplayChanger.this.extractUUID(original.getName()).toString(), displayName != null ? displayName : original.getName());
                PlayerDisplayChanger.this.updateSkin(result, skinName != null ? skinName : result.getName());
                profiles.write(0, (Object)result);
            }
        }).start(4);
    }

    private UUID extractUUID(String playerName) {
        return Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
    }

    private String getProfileJson(String name) throws IOException {
        URL url = new URL(PROFILE_URL + this.extractUUID(name).toString().replace("-", ""));
        final URLConnection uc = url.openConnection();
        return CharStreams.toString((InputSupplier)new InputSupplier<InputStreamReader>(){

            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader(uc.getInputStream(), Charsets.UTF_8);
            }
        });
    }

    private void updateSkin(WrappedGameProfile profile, String skinOwner) {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse((String)this.profileCache.get((Object)skinOwner));
            JSONArray properties = (JSONArray)json.get((Object)"properties");
            for (int i = 0; i < properties.size(); ++i) {
                JSONObject property = (JSONObject)properties.get(i);
                String name = (String)property.get((Object)"name");
                String value = (String)property.get((Object)"value");
                String signature = (String)property.get((Object)"signature");
                profile.getProperties().put((Object)name, (Object)new WrappedSignedProperty(name, value, signature));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot fetch profile for " + skinOwner, e);
        }
    }

    public void changeDisplay(String string, String toSkin) {
        this.changeDisplay(string, toSkin, null);
    }

    public void changeDisplay(Player player, String toSkin, String toName) {
        if (this.updateMap(this.skinNames, player.getName(), toSkin) | this.updateMap(this.displayNames, player.getName(), toName)) {
            this.refreshPlayer(player);
        }
    }

    public void changeDisplay(String playerName, String toSkin, String toName) {
        if (this.updateMap(this.skinNames, playerName, toSkin) | this.updateMap(this.displayNames, playerName, toName)) {
            this.refreshPlayer(playerName);
        }
    }

    public void removeChanges(Player player) {
        this.changeDisplay(player.getName(), null, null);
    }

    public void removeChanges(String playerName) {
        this.changeDisplay(playerName, null, null);
    }

    private <T, U> boolean updateMap(Map<T, U> map, T key, U value) {
        if (value == null) {
            return map.remove(key) != null;
        }
        return !Objects.equal(value, map.put(key, value));
    }

    private void refreshPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            this.refreshPlayer(player);
        }
    }

    private void refreshPlayer(Player player) {
        this.protocolManager.updateEntity((Entity)player, this.protocolManager.getEntityTrackers((Entity)player));
    }
}

