/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.packet;

import com.w00tmast3r.skquery.SkQuery;
import com.w00tmast3r.skquery.util.Reflection;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class BossBars
implements Listener {
    public static BossBars instance = null;
    private static PlayerMap<FakeDragon> DRAGONS;

    private BossBars() {
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        BossBars.removeStatusBar(event.getPlayer());
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        BossBars.removeStatusBar(event.getPlayer());
    }

    public static boolean hasStatusBar(Player player) {
        return DRAGONS.containsKey(player) && DRAGONS.get(player) != null;
    }

    public static void removeStatusBar(Player player) {
        if (BossBars.hasStatusBar(player)) {
            Reflection.sendPacket(DRAGONS.get(player).getDestroyPacket(), player);
            DRAGONS.remove(player);
        }
    }

    public static void setStatusBar(Player player, String text, float percent) {
        FakeDragon dragon;
        FakeDragon fakeDragon = dragon = DRAGONS.containsKey(player) ? DRAGONS.get(player) : null;
        if (text.length() > 64) {
            text = text.substring(0, 63);
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < 0.05f) {
            percent = 0.05f;
        }
        if (text.isEmpty() && dragon != null) {
            BossBars.removeStatusBar(player);
        }
        if (dragon == null) {
            dragon = new FakeDragon(player.getLocation().add(0.0, -200.0, 0.0), text, percent);
            Reflection.sendPacket(dragon.getSpawnPacket(), player);
            DRAGONS.put(player, dragon);
        } else {
            dragon.setName(text);
            dragon.setHealth(percent);
            Reflection.sendPacket(dragon.getMetaPacket(dragon.getWatcher()), player);
            Reflection.sendPacket(dragon.getTeleportPacket(player.getLocation().add(0.0, -200.0, 0.0)), player);
        }
    }

    public static void removeAllStatusBars() {
        for (Player each : Bukkit.getOnlinePlayers()) {
            BossBars.removeStatusBar(each);
        }
    }

    public static void setAllStatusBars(String text, float percent) {
        for (Player each : Bukkit.getOnlinePlayers()) {
            BossBars.setStatusBar(each, text, percent);
        }
    }

    static {
        if (instance == null) {
            instance = new BossBars();
            Bukkit.getPluginManager().registerEvents((Listener)instance, (Plugin)SkQuery.getInstance());
        }
        DRAGONS = new PlayerMap();
    }

    private static class PlayerMap<V>
    implements Map<Player, V> {
        private final V defaultValue = null;
        private final Map<String, V> contents = new HashMap<String, V>();

        @Override
        public void clear() {
            this.contents.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof Player) {
                return this.contents.containsKey(((Player)key).getName());
            }
            return key instanceof String && this.contents.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.contents.containsValue(value);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<Player, V>> entrySet() {
            HashSet<Map.Entry<Player, V>> toReturn = new HashSet<Map.Entry<Player, V>>();
            for (String name : this.contents.keySet()) {
                toReturn.add(new PlayerEntry(Bukkit.getPlayer((String)name), this.contents.get(name)));
            }
            return toReturn;
        }

        @Override
        public V get(Object key) {
            V result = null;
            if (key instanceof Player) {
                result = this.contents.get(((Player)key).getName());
            }
            if (key instanceof String) {
                result = this.contents.get(key);
            }
            return result == null ? (V)this.defaultValue : result;
        }

        @Override
        public boolean isEmpty() {
            return this.contents.isEmpty();
        }

        @Override
        @Nonnull
        public Set<Player> keySet() {
            HashSet<Player> toReturn = new HashSet<Player>();
            for (String name : this.contents.keySet()) {
                toReturn.add(Bukkit.getPlayer((String)name));
            }
            return toReturn;
        }

        @Override
        public V put(Player key, V value) {
            if (key == null) {
                return null;
            }
            return this.contents.put(key.getName(), value);
        }

        @Override
        public void putAll(@Nonnull Map<? extends Player, ? extends V> map) {
            for (Map.Entry<Player, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            if (key instanceof Player) {
                return this.contents.remove(((Player)key).getName());
            }
            if (key instanceof String) {
                return this.contents.remove(key);
            }
            return null;
        }

        @Override
        public int size() {
            return this.contents.size();
        }

        @Override
        @Nonnull
        public Collection<V> values() {
            return this.contents.values();
        }

        public String toString() {
            return this.contents.toString();
        }

        public class PlayerEntry
        implements Map.Entry<Player, V> {
            private Player key;
            private V value;

            public PlayerEntry(Player key, V value) {
                this.key = key;
                this.value = value;
            }

            @Override
            public Player getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value) {
                Object toReturn = this.value;
                this.value = value;
                return toReturn;
            }
        }
    }

    private static class FakeDragon {
        private static final int MAX_HEALTH = 200;
        private int id;
        private int x;
        private int y;
        private int z;
        private int pitch = 0;
        private int yaw = 0;
        private byte xV = 0;
        private byte yV = 0;
        private byte zV = 0;
        private float health;
        private boolean visible = false;
        private String name;
        private Object world;
        private Object dragon;

        public FakeDragon(Location loc, String name, float percent) {
            this.name = name;
            this.x = loc.getBlockX();
            this.y = loc.getBlockY();
            this.z = loc.getBlockZ();
            this.health = percent * 200.0f;
            this.world = Reflection.getHandle(loc.getWorld());
        }

        public void setHealth(float percent) {
            this.health = percent / 200.0f;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getSpawnPacket() {
            Class Entity2 = Reflection.nmsClass("Entity");
            Class EntityLiving = Reflection.nmsClass("EntityLiving");
            Class EntityEnderDragon = Reflection.nmsClass("EntityEnderDragon");
            try {
                this.dragon = EntityEnderDragon.getConstructor(Reflection.nmsClass("World")).newInstance(this.world);
                Reflection.getMethod(EntityEnderDragon, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(this.dragon, this.x, this.y, this.z, this.pitch, this.yaw);
                Reflection.getMethod(EntityEnderDragon, "setInvisible", Boolean.TYPE).invoke(this.dragon, this.visible);
                Reflection.getMethod(EntityEnderDragon, "setCustomName", String.class).invoke(this.dragon, this.name);
                Reflection.getMethod(EntityEnderDragon, "setHealth", Float.TYPE).invoke(this.dragon, Float.valueOf(this.health));
                Reflection.getField(Entity2, "motX").set(this.dragon, this.xV);
                Reflection.getField(Entity2, "motY").set(this.dragon, this.yV);
                Reflection.getField(Entity2, "motZ").set(this.dragon, this.zV);
                this.id = (Integer)Reflection.getMethod(EntityEnderDragon, "getId", new Class[0]).invoke(this.dragon, new Object[0]);
                Class packetClass = Reflection.nmsClass("PacketPlayOutSpawnEntityLiving");
                return packetClass.getConstructor(EntityLiving).newInstance(this.dragon);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getDestroyPacket() {
            try {
                Class packetClass = Reflection.nmsClass("PacketPlayOutEntityDestroy");
                return packetClass.getConstructor(int[].class).newInstance(new Object[]{new int[]{this.id}});
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getMetaPacket(Object watcher) {
            try {
                Class watcherClass = Reflection.nmsClass("DataWatcher");
                Class packetClass = Reflection.nmsClass("PacketPlayOutEntityMetadata");
                return packetClass.getConstructor(Integer.TYPE, watcherClass, Boolean.TYPE).newInstance(this.id, watcher, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getTeleportPacket(Location loc) {
            try {
                Class packetClass = Reflection.nmsClass("PacketPlayOutEntityTeleport");
                return packetClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Byte.TYPE, Byte.TYPE).newInstance(this.id, loc.getBlockX() * 32, loc.getBlockY() * 32, loc.getBlockZ() * 32, (byte)((int)loc.getYaw() * 256 / 360), (byte)((int)loc.getPitch() * 256 / 360));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Object getWatcher() {
            Class Entity2 = Reflection.nmsClass("Entity");
            Class DataWatcher = Reflection.nmsClass("DataWatcher");
            try {
                Object watcher = DataWatcher.getConstructor(Entity2).newInstance(this.dragon);
                Method a = Reflection.getMethod(DataWatcher, "a", Integer.TYPE, Object.class);
                a.invoke(watcher, 0, this.visible ? (byte)0 : 32);
                a.invoke(watcher, 6, Float.valueOf(this.health));
                a.invoke(watcher, 7, 0);
                a.invoke(watcher, 8, (byte)0);
                a.invoke(watcher, 10, this.name);
                a.invoke(watcher, 11, (byte)1);
                return watcher;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class BossBarProxy {
        private final UUID playerReference;

        public BossBarProxy(OfflinePlayer p) {
            this.playerReference = p.getUniqueId();
        }

        public Player getPlayer() {
            return Bukkit.getPlayer((UUID)this.playerReference);
        }

        public void removeBar() {
            BossBars.removeStatusBar(this.getPlayer());
        }

        public void setText(String text) {
            BossBars.setStatusBar(this.getPlayer(), text, this.getPercent());
        }

        public String getText() {
            return DRAGONS.containsKey(this.getPlayer()) ? ((FakeDragon)DRAGONS.get(this.getPlayer())).name : "";
        }

        public void setPercent(float percent) {
            if (percent == 0.0f) {
                this.removeBar();
            } else {
                BossBars.setStatusBar(this.getPlayer(), this.getText(), percent);
            }
        }

        public float getPercent() {
            return DRAGONS.containsKey(this.getPlayer()) ? ((FakeDragon)DRAGONS.get(this.getPlayer())).health / 200.0f : 0.0f;
        }
    }
}

