/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.custom.menus.v1_;

import com.w00tmast3r.skquery.SkQuery;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public class VirtualChestManager
implements Listener {
    private final String inventoryName;
    private final String player;
    private final List<String>[] commands;

    public VirtualChestManager(String inventoryName, String player, List<String>[] commands) {
        this.inventoryName = inventoryName;
        this.player = player;
        this.commands = commands;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getCurrentItem() != null && e.getCurrentItem().getType() != Material.AIR && e.getInventory().getType() == InventoryType.CHEST && e.getCurrentItem().getItemMeta() != null && e.getCurrentItem().getItemMeta().getLore().contains(ChatColor.translateAlternateColorCodes((char)'&', (String)"&0&0&0&0&0&0&0&0")) && e.getInventory().getName().equalsIgnoreCase(this.inventoryName) && e.getWhoClicked().getName().equalsIgnoreCase(this.player)) {
            e.setCancelled(true);
            this.safeClose((Player)e.getWhoClicked());
            if (this.commands[e.getSlot()] != null) {
                for (String s : this.commands[e.getSlot()]) {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), s);
                }
            }
            HandlerList.unregisterAll((Listener)this);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getPlayer().getName().equalsIgnoreCase(this.player) && e.getInventory().getName().equalsIgnoreCase(this.inventoryName)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    private void safeClose(final Player p) {
        Bukkit.getScheduler().runTaskLater((Plugin)SkQuery.getInstance(), new Runnable(){

            @Override
            public void run() {
                p.getOpenInventory().close();
            }
        }, 1L);
    }

    public static void startListener() {
    }
}

