/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.EmptyIterator;
import ch.njol.util.coll.iterator.IteratorIterable;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.custom.region.CuboidIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

@Patterns(value={"blocks within %location% to %location%"})
public class ExprBlockCube
extends SimpleExpression<Block> {
    private Expression<Location> pos1;
    private Expression<Location> pos2;

    protected Block[] get(Event event) {
        Location p1 = (Location)this.pos1.getSingle(event);
        Location p2 = (Location)this.pos2.getSingle(event);
        if (p1 == null || p2 == null) {
            return null;
        }
        ArrayList<Block> list = new ArrayList<Block>();
        for (Block b : new IteratorIterable(this.iterator(event))) {
            list.add(b);
        }
        return list.toArray(new Block[list.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public String toString(Event event, boolean b) {
        return "cuboid";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.pos1 = expressions[0];
        this.pos2 = expressions[1];
        return true;
    }

    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("block");
    }

    public Iterator<Block> iterator(Event e) {
        Location p1 = (Location)this.pos1.getSingle(e);
        Location p2 = (Location)this.pos2.getSingle(e);
        if (p1 == null || p2 == null) {
            return new EmptyIterator();
        }
        return new CuboidIterator(p1, p2);
    }
}

