/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Description;
import com.w00tmast3r.skquery.api.Examples;
import com.w00tmast3r.skquery.api.Name;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.maps.SkriptMapRenderer;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.map.MapView;

@Name(value="Manage Map")
@Description(value="Allows maps to be controlled by skQuery. Using 'manage' will share the renderer with other custom map renderers. 'Override' deletes existing renderers.")
@Examples(value={"manage map 1", "override map 2"})
@Patterns(value={"(manage|share) map [id] %number%", "(override|overwrite) map [id] %number%"})
public class EffManageMap
extends Effect {
    private Expression<Number> id;
    private boolean overwrite;

    protected void execute(Event event) {
        MapView mapView;
        Number n = (Number)this.id.getSingle(event);
        if (n == null) {
            return;
        }
        short id = n.shortValue();
        try {
            mapView = Bukkit.getMap((short)id);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Map " + id + " has not been initialized yet!");
            return;
        }
        SkriptMapRenderer.createHandle(mapView, this.overwrite);
    }

    public String toString(Event event, boolean b) {
        return "manage skript maps";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.id = expressions[0];
        this.overwrite = i == 1;
        return true;
    }
}

