/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

public class ScriptCredentials {
    private static HashMap<File, ScriptCredentials> credentials = new HashMap();
    private String url = null;
    private String username = null;
    private String password = null;
    private Connection connection = null;

    private ScriptCredentials() {
    }

    public static void setURL(File script, String url) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.url = url;
        sc.validate();
    }

    public static void setUsername(File script, String username) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.username = username;
        sc.validate();
    }

    public static void setPassword(File script, String password) {
        ScriptCredentials sc = ScriptCredentials.get(script);
        sc.password = password;
        sc.validate();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static ScriptCredentials get(File script) {
        if (!credentials.containsKey(script)) {
            credentials.put(script, new ScriptCredentials());
        }
        ScriptCredentials c = credentials.get(script);
        try {
            if (c.connection != null && !c.connection.isValid(1)) {
                c.validate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return c;
    }

    public static void clear() {
        for (ScriptCredentials sc : credentials.values()) {
            if (sc.connection == null) continue;
            try {
                sc.connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void validate() {
        if (this.url != null && this.username != null && this.password != null) {
            try {
                this.connection = DriverManager.getConnection(this.url, this.username, this.password);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

