/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util;

public class RomanNumerals {
    public static String toRoman(int number) {
        String[] roman = new String[]{"M", "XM", "CM", "D", "XD", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        int[] arab = new int[]{1000, 990, 900, 500, 490, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (number > 0 || arab.length == i - 1) {
            while (number - arab[i] >= 0) {
                number -= arab[i];
                result.append(roman[i]);
            }
            ++i;
        }
        return result.toString();
    }

    public static int fromRoman(String number) {
        if (number.startsWith("M")) {
            return 1000 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("CM")) {
            return 900 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("D")) {
            return 500 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("CD")) {
            return 400 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("C")) {
            return 100 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("XC")) {
            return 90 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("L")) {
            return 50 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("XL")) {
            return 40 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("X")) {
            return 10 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("IX")) {
            return 9 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("V")) {
            return 5 + RomanNumerals.fromRoman(number.substring(1));
        }
        if (number.startsWith("IV")) {
            return 4 + RomanNumerals.fromRoman(number.substring(2));
        }
        if (number.startsWith("I")) {
            return 1 + RomanNumerals.fromRoman(number.substring(1));
        }
        return 0;
    }
}

