/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.w00tmast3r.skquery.api.Patterns;
import com.w00tmast3r.skquery.util.Collect;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Patterns(value={"yaml (1\u00a6value|2\u00a6nodes|3\u00a6nodes with keys|4\u00a6list) %string% from [file] %string%"})
public class ExprYAMLValue
extends SimpleExpression<Object> {
    private State type;
    private Expression<String> path;
    private Expression<String> file;

    protected Object[] get(Event e) {
        String p = (String)this.path.getSingle(e);
        String f = (String)this.file.getSingle(e);
        if (p == null || f == null) {
            return null;
        }
        File file = new File(Skript.getInstance().getDataFolder() + "/scripts/" + (f.contains(".") ? f : f + ".yml"));
        try {
            file.createNewFile();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        if (!cfg.contains(p)) {
            return null;
        }
        switch (this.type) {
            case VALUE: {
                if (cfg.isConfigurationSection(p)) {
                    return null;
                }
                return Collect.asArray(cfg.get(p));
            }
            case NODES: {
                if (!cfg.isConfigurationSection(p)) {
                    return null;
                }
                Set nodes = cfg.getConfigurationSection(p).getKeys(false);
                return nodes.toArray(new String[nodes.size()]);
            }
            case NODES_KEYS: {
                if (!cfg.isConfigurationSection(p)) {
                    return null;
                }
                Set nodesKeys = cfg.getConfigurationSection(p).getKeys(true);
                return nodesKeys.toArray(new String[nodesKeys.size()]);
            }
            case LIST: {
                if (cfg.isConfigurationSection(p)) {
                    return null;
                }
                List items = cfg.getList(p);
                return items.toArray();
            }
        }
        assert (false);
        return null;
    }

    public boolean isSingle() {
        return this.type == State.VALUE;
    }

    public Class<?> getReturnType() {
        return Object.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "yaml";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        switch (parseResult.mark) {
            case 1: {
                this.type = State.VALUE;
                break;
            }
            case 2: {
                this.type = State.NODES;
                break;
            }
            case 3: {
                this.type = State.NODES_KEYS;
                break;
            }
            case 4: {
                this.type = State.LIST;
            }
        }
        this.path = exprs[0];
        this.file = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE) {
            return Collect.asArray(Object.class);
        }
        switch (this.type) {
            case VALUE: {
                if (mode != Changer.ChangeMode.SET) break;
                return Collect.asArray(Object.class);
            }
            case NODES: 
            case NODES_KEYS: 
            case LIST: {
                if (mode != Changer.ChangeMode.ADD && mode != Changer.ChangeMode.REMOVE) break;
                return Collect.asArray(Object.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String p = (String)this.path.getSingle(e);
        String f = (String)this.file.getSingle(e);
        if (p == null) return;
        if (f == null) {
            return;
        }
        File file = new File(Skript.getInstance().getDataFolder() + "/scripts/" + (f.contains(".") ? f : f + ".yml"));
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        try {
            if (mode == Changer.ChangeMode.DELETE) {
                cfg.set(p, null);
                return;
            }
            String target = delta[0] == null ? "" : delta[0];
            switch (this.type) {
                case VALUE: {
                    switch (mode) {
                        case SET: {
                            cfg.set(p, delta[0]);
                            return;
                        }
                    }
                    return;
                }
                case NODES: 
                case NODES_KEYS: {
                    switch (mode) {
                        case ADD: {
                            cfg.createSection(p);
                            return;
                        }
                        case REMOVE: {
                            cfg.set(p + "." + target, null);
                            return;
                        }
                    }
                    return;
                }
                case LIST: {
                    switch (mode) {
                        case ADD: {
                            cfg.getList(p).add(delta[0]);
                            return;
                        }
                        case REMOVE: {
                            cfg.getList(p).remove(delta[0]);
                        }
                    }
                    return;
                }
            }
            return;
        }
        finally {
            try {
                cfg.save(file);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static enum State {
        VALUE,
        NODES,
        NODES_KEYS,
        LIST;

    }
}

