/*
 * Decompiled with CFR 0.152.
 */
package com.w00tmast3r.skquery.util.minecraft;

import com.w00tmast3r.skquery.util.Reflection;
import com.w00tmast3r.skquery.util.minecraft.MessagePart;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Achievement;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.libs.com.google.gson.stream.JsonWriter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class JSONMessage {
    private final List<MessagePart> messageParts;
    private String jsonString;
    private boolean dirty;
    private Class<?> nmsChatSerializer = Reflection.nmsClass("ChatSerializer");
    private Class<?> nmsTagCompound = Reflection.nmsClass("NBTTagCompound");
    private Class<?> nmsPacketPlayOutChat = Reflection.nmsClass("PacketPlayOutChat");
    private Class<?> nmsAchievement = Reflection.nmsClass("Achievement");
    private Class<?> nmsStatistic = Reflection.nmsClass("Statistic");
    private Class<?> nmsItemStack = Reflection.nmsClass("ItemStack");
    private Class<?> obcStatistic = Reflection.obcClass("CraftStatistic");
    private Class<?> obcItemStack = Reflection.obcClass("inventory.CraftItemStack");

    public JSONMessage(String firstPartText) {
        this.messageParts = new ArrayList<MessagePart>();
        this.messageParts.add(new MessagePart(firstPartText));
        this.jsonString = null;
        this.dirty = false;
    }

    public JSONMessage color(ChatColor color) {
        if (!color.isColor()) {
            throw new IllegalArgumentException(color.name() + " is not a color");
        }
        this.latest().color = color;
        this.dirty = true;
        return this;
    }

    public JSONMessage style(ChatColor ... styles) {
        for (ChatColor style : styles) {
            if (style.isFormat()) continue;
            throw new IllegalArgumentException(style.name() + " is not a style");
        }
        this.latest().styles = styles;
        this.dirty = true;
        return this;
    }

    public JSONMessage file(String path) {
        this.onClick("open_file", path);
        return this;
    }

    public JSONMessage link(String url) {
        this.onClick("open_url", url);
        return this;
    }

    public JSONMessage suggest(String command) {
        this.onClick("suggest_command", command);
        return this;
    }

    public JSONMessage command(String command) {
        this.onClick("run_command", command);
        return this;
    }

    public JSONMessage achievementTooltip(String name) {
        this.onHover("show_achievement", "achievement." + name);
        return this;
    }

    public JSONMessage achievementTooltip(Achievement which) {
        try {
            Object achievement = Reflection.getMethod(this.obcStatistic, "getNMSAchievement", new Class[0]).invoke(null, which);
            return this.achievementTooltip((String)Reflection.getField(this.nmsAchievement, "name").get(achievement));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public JSONMessage itemTooltip(String itemJSON) {
        this.onHover("show_item", itemJSON);
        return this;
    }

    public JSONMessage itemTooltip(ItemStack itemStack) {
        try {
            Object nmsItem = Reflection.getMethod(this.obcItemStack, "asNMSCopy", ItemStack.class).invoke(null, itemStack);
            return this.itemTooltip(Reflection.getMethod(this.nmsItemStack, "save", new Class[0]).invoke(nmsItem, this.nmsTagCompound.newInstance()).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return this;
        }
    }

    public JSONMessage tooltip(String text) {
        return this.tooltip(text.split("\\n"));
    }

    public JSONMessage tooltip(List<String> lines) {
        return this.tooltip((String[])lines.toArray());
    }

    public JSONMessage tooltip(String ... lines) {
        if (lines.length == 1) {
            this.onHover("show_text", lines[0]);
        } else {
            this.itemTooltip(this.makeMultilineTooltip(lines));
        }
        return this;
    }

    public JSONMessage then(Object obj) {
        this.messageParts.add(new MessagePart(obj.toString()));
        this.dirty = true;
        return this;
    }

    public String toJSONString() {
        if (!this.dirty && this.jsonString != null) {
            return this.jsonString;
        }
        StringWriter string = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)string);
        try {
            if (this.messageParts.size() == 1) {
                this.latest().writeJson(json);
            } else {
                json.beginObject().name("text").value("").name("extra").beginArray();
                for (MessagePart part : this.messageParts) {
                    part.writeJson(json);
                }
                json.endArray().endObject();
                json.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("invalid message");
        }
        this.jsonString = string.toString();
        this.dirty = false;
        return this.jsonString;
    }

    public void send(Player ... players) {
        try {
            Object serialized = Reflection.getMethod(this.nmsChatSerializer, "a", String.class).invoke(null, this.toJSONString());
            Object packet = this.nmsPacketPlayOutChat.getConstructor(Reflection.nmsClass("IChatBaseComponent")).newInstance(serialized);
            Reflection.sendPacket(packet, players);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toOldMessageFormat() {
        StringBuilder result = new StringBuilder();
        for (MessagePart part : this.messageParts) {
            result.append(part.color).append(part.text);
        }
        return result.toString();
    }

    private MessagePart latest() {
        return this.messageParts.get(this.messageParts.size() - 1);
    }

    private String makeMultilineTooltip(String[] lines) {
        StringWriter string = new StringWriter();
        JsonWriter json = new JsonWriter((Writer)string);
        try {
            json.beginObject().name("id").value(1L);
            json.name("tag").beginObject().name("display").beginObject();
            json.name("Name").value("\\u00A7f" + lines[0].replace("\"", "\\\""));
            json.name("Lore").beginArray();
            for (int i = 1; i < lines.length; ++i) {
                String line = lines[i];
                json.value(line.isEmpty() ? " " : line.replace("\"", "\\\""));
            }
            json.endArray().endObject().endObject().endObject();
            json.close();
        }
        catch (Exception e) {
            throw new RuntimeException("invalid tooltip");
        }
        return string.toString();
    }

    private void onClick(String name, String data) {
        MessagePart latest = this.latest();
        latest.clickActionName = name;
        latest.clickActionData = data;
        this.dirty = true;
    }

    private void onHover(String name, String data) {
        MessagePart latest = this.latest();
        latest.hoverActionName = name;
        latest.hoverActionData = data;
        this.dirty = true;
    }
}

