/*
 * Decompiled with CFR 0.152.
 */
package com.Morkaz.skMorkaz.main;

import com.Morkaz.skMorkaz.main.ConfigLoader;
import com.Morkaz.skMorkaz.main.main;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SSLEmailSender {
    private String username = ConfigLoader.emailUsername;
    private String password = ConfigLoader.emailPassword;
    private Properties mailProps = new Properties();

    public SSLEmailSender() {
        this.mailProps.put("mail.smtp.auth", ConfigLoader.emailPasswordRequired);
        this.mailProps.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        this.mailProps.put("mail.smtp.host", ConfigLoader.emailServerHost);
        this.mailProps.put("mail.smtp.port", (Object)ConfigLoader.emailPort);
        this.mailProps.put("mail.smtp.socketFactory.port", (Object)ConfigLoader.emailPort);
        this.mailProps.put("mail.smtp.timeout", (Object)10000);
        this.mailProps.put("mail.smtp.connectiontimeout", (Object)10000);
    }

    public void send(final String subject, final String text, final String address) {
        new BukkitRunnable(){

            public void run() {
                Session session = Session.getDefaultInstance((Properties)SSLEmailSender.this.mailProps, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(SSLEmailSender.this.username, SSLEmailSender.this.password);
                    }
                });
                try {
                    session.setDebug(false);
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(SSLEmailSender.this.username));
                    message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)address));
                    message.setSubject(subject);
                    message.setText(text);
                    Transport transport = session.getTransport("smtp");
                    transport.connect(ConfigLoader.emailServerHost, ConfigLoader.emailPort, SSLEmailSender.this.username, SSLEmailSender.this.password);
                    transport.sendMessage((Message)message, message.getAllRecipients());
                    transport.close();
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
            }
        }.runTaskAsynchronously((Plugin)main.getIntance());
    }
}

