/*
 * Decompiled with CFR 0.152.
 */
package com.Morkaz.skMorkaz.main;

import com.Morkaz.skMorkaz.main.ConfigLoader;
import com.Morkaz.skMorkaz.main.main;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TLSEmailSender {
    private String username = ConfigLoader.emailUsername;
    private String password = ConfigLoader.emailPassword;
    private Properties mailProps = new Properties();

    public TLSEmailSender() {
        this.mailProps.put("mail.smtp.auth", ConfigLoader.emailPasswordRequired);
        this.mailProps.put("mail.smtp.starttls.enable", "true");
        this.mailProps.put("mail.smtp.host", ConfigLoader.emailServerHost);
        this.mailProps.put("mail.smtp.port", (Object)ConfigLoader.emailPort);
        this.mailProps.put("mail.smtp.timeout", (Object)3000);
        this.mailProps.put("mail.smtp.connectiontimeout", (Object)3000);
    }

    public void send(final String subject, final String text, final String address) {
        new BukkitRunnable(){

            public void run() {
                try {
                    Session session = Session.getInstance((Properties)TLSEmailSender.this.mailProps, (Authenticator)new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(TLSEmailSender.this.username, TLSEmailSender.this.password);
                        }
                    });
                    session.setDebug(false);
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(TLSEmailSender.this.username));
                    message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)address));
                    message.setSubject(subject);
                    MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
                    mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
                    mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
                    mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
                    mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
                    mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
                    CommandMap.setDefaultCommandMap((CommandMap)mc);
                    message.setText(text);
                    Transport.send((Message)message);
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }.runTaskAsynchronously((Plugin)main.getIntance());
    }
}

