/*
 * Decompiled with CFR 0.152.
 */
package me.Funnygatt.SkExtras.Expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ExprBlockDrops
extends SimpleExpression<ItemStack> {
    private Kleenean delayed;

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(BlockBreakEvent.class)) {
            Skript.error((String)"The expression 'block drops' can only be used in block break events", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.delayed = isDelayed;
        return true;
    }

    @Nullable
    protected ItemStack[] get(Event event) {
        if (!(event instanceof BlockBreakEvent)) {
            return new ItemStack[0];
        }
        return ((BlockBreakEvent)event).getBlock().getDrops().toArray(new ItemStack[0]);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.RESET) {
            return null;
        }
        if (this.delayed.isTrue()) {
            Skript.error((String)"Can't change the drops anymore after the event has already passed");
            return null;
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType[].class, Inventory[].class, Experience[].class});
    }

    public void change(Event e, @Nullable Object[] deltas, Changer.ChangeMode mode) {
        assert (mode != Changer.ChangeMode.RESET);
        if (!(e instanceof BlockBreakEvent)) {
            assert (false);
            return;
        }
        boolean cleared = false;
        if (mode == Changer.ChangeMode.DELETE) {
            cleared = true;
            return;
        }
        assert (deltas != null);
        block6: for (Object delta : deltas) {
            switch (mode) {
                case SET: {
                    if (!cleared) {
                        cleared = true;
                    }
                }
                case ADD: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable((Iterator)((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            ((BlockBreakEvent)e).getBlock().getDrops().add(is);
                        }
                        continue block6;
                    }
                    ((BlockBreakEvent)e).getBlock().getDrops().add((ItemStack)delta);
                    continue block6;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    if (delta instanceof Inventory) {
                        for (ItemStack is : new IteratorIterable((Iterator)((Inventory)delta).iterator())) {
                            if (is == null) continue;
                            if (mode == Changer.ChangeMode.REMOVE) {
                                ((BlockBreakEvent)e).getBlock().getDrops().remove(is);
                                continue;
                            }
                            ((BlockBreakEvent)e).getBlock().getDrops().clear();
                        }
                        continue block6;
                    }
                    if (mode == Changer.ChangeMode.REMOVE) {
                        ((BlockBreakEvent)e).getBlock().getDrops().remove(delta);
                        continue block6;
                    }
                    ((BlockBreakEvent)e).getBlock().getDrops().clear();
                    continue block6;
                }
                case DELETE: 
                case RESET: {
                    if (!cleared) {
                        ((BlockBreakEvent)e).getBlock().getDrops().clear();
                    }
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "block drops";
        }
        return Classes.getDebugMessage((Object)this.getAll(e));
    }

    public boolean isSingle() {
        return false;
    }
}

